/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.block_templates;

import aurocosh.divinefavor.common.block_templates.BlockTemplate;
import aurocosh.divinefavor.common.block_templates.BlockTemplateCompatibilitySerializer;
import aurocosh.divinefavor.common.lib.BlockMapIntState;
import aurocosh.divinefavor.common.lib.extensions.NbtTagExtensionsKt;
import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import aurocosh.divinefavor.common.util.UtilBlockPos;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Laurocosh/divinefavor/common/block_templates/BlockTemplateCompatibilitySerializer;", "", "()V", "tagDimension", "", "tagEndPos", "tagKey", "tagMapIntState", "tagPosIntArray", "tagStartPos", "tagStateIntArray", "tagValue", "deserialize", "Laurocosh/divinefavor/common/block_templates/BlockTemplate;", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "posFromNbtTag", "Lnet/minecraft/util/math/BlockPos;", "tagCompound", "tagName", "serialize", "template", "divinefavor"})
public final class BlockTemplateCompatibilitySerializer {
    private static final String tagMapIntState = "mapIntState";
    private static final String tagPosIntArray = "posIntArray";
    private static final String tagStateIntArray = "stateIntArray";
    private static final String tagStartPos = "startPos";
    private static final String tagEndPos = "endPos";
    private static final String tagDimension = "dim";
    private static final String tagKey = "mapSlot";
    private static final String tagValue = "mapState";
    public static final BlockTemplateCompatibilitySerializer INSTANCE;

    @NotNull
    public final NBTTagCompound serialize(@NotNull BlockTemplate template) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        NBTTagCompound compound = new NBTTagCompound();
        NbtTagExtensionsKt.setMap(compound, tagMapIntState, template.getBlockMapIntState().getIntStateMap(), serialize.1.INSTANCE, serialize.2.INSTANCE, tagKey, tagValue);
        compound.func_74783_a(tagPosIntArray, template.getPosIntArray());
        compound.func_74783_a(tagStateIntArray, template.getStateIntArray());
        compound.func_74782_a(tagStartPos, (NBTBase)NBTUtil.func_186859_a((BlockPos)template.getBoundingBox().getLowerCorner()));
        compound.func_74782_a(tagEndPos, (NBTBase)NBTUtil.func_186859_a((BlockPos)template.getBoundingBox().getUpperCorner()));
        compound.func_74768_a(tagDimension, 0);
        return compound;
    }

    @NotNull
    public final BlockTemplate deserialize(@NotNull NBTTagCompound compound, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Map intStateMap2 = NbtTagExtensionsKt.getMap(compound, tagMapIntState, deserialize.intStateMap.1.INSTANCE, deserialize.intStateMap.2.INSTANCE, tagKey, tagValue);
        BlockPos startPos = this.posFromNbtTag(compound, tagStartPos);
        BlockPos endPos = this.posFromNbtTag(compound, tagEndPos);
        CuboidBoundingBox boundingBox = new CuboidBoundingBox(startPos, endPos);
        int[] stateIntArray = compound.func_74759_k(tagStateIntArray);
        int[] posIntArray = compound.func_74759_k(tagPosIntArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)posIntArray, (String)tagPosIntArray);
        int[] fixedIntArray2 = CollectionsKt.toIntArray((Collection)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((int[])posIntArray), (Function1)((Function1)new Function1<Integer, BlockPos>(UtilBlockPos.INSTANCE){

            @NotNull
            public final BlockPos invoke(int p1) {
                return ((UtilBlockPos)this.receiver).intToBlockPos(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UtilBlockPos.class);
            }

            public final String getName() {
                return "intToBlockPos";
            }

            public final String getSignature() {
                return "intToBlockPos(I)Lnet/minecraft/util/math/BlockPos;";
            }
        })), (Function1)((Function1)new Function1<Vec3i, BlockPos>(startPos){

            public final BlockPos invoke(Vec3i p1) {
                return ((BlockPos)this.receiver).func_177971_a(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(BlockPos.class);
            }

            public final String getName() {
                return "add";
            }

            public final String getSignature() {
                return "add(Lnet/minecraft/util/math/Vec3i;)Lnet/minecraft/util/math/BlockPos;";
            }
        })), (Function1)((Function1)new Function1<BlockPos, BlockPos>(boundingBox){
            final /* synthetic */ CuboidBoundingBox $boundingBox;

            public final BlockPos invoke(BlockPos it) {
                return it.func_177973_b((Vec3i)this.$boundingBox.getLowerCorner());
            }
            {
                this.$boundingBox = cuboidBoundingBox;
                super(1);
            }
        })), (Function1)((Function1)new Function1<BlockPos, Integer>(UtilBlockPos.INSTANCE){

            public final int invoke(@NotNull BlockPos p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((UtilBlockPos)this.receiver).blockPosToInt(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UtilBlockPos.class);
            }

            public final String getName() {
                return "blockPosToInt";
            }

            public final String getSignature() {
                return "blockPosToInt(Lnet/minecraft/util/math/BlockPos;)I";
            }
        }))));
        BlockMapIntState blockMapIntState = new BlockMapIntState(intStateMap2, null, 2, null);
        blockMapIntState.generateStackMapFromStateMap(player);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
        Intrinsics.checkExpressionValueIsNotNull((Object)stateIntArray, (String)tagStateIntArray);
        CuboidBoundingBox cuboidBoundingBox = boundingBox.moveToOrigin();
        String string = player.func_70005_c_();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"player.name");
        return new BlockTemplate(uUID, blockMapIntState, fixedIntArray2, stateIntArray, cuboidBoundingBox, 0, string, null, 128, null);
    }

    private final BlockPos posFromNbtTag(NBTTagCompound tagCompound, String tagName) {
        BlockPos blockPos2;
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (Intrinsics.areEqual((Object)posTag, (Object)new NBTTagCompound())) {
            BlockPos blockPos3 = BlockPos.field_177992_a;
            blockPos2 = blockPos3;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"BlockPos.ORIGIN");
        } else {
            BlockPos blockPos4 = NBTUtil.func_186861_c((NBTTagCompound)posTag);
            blockPos2 = blockPos4;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"NBTUtil.getPosFromTag(posTag)");
        }
        return blockPos2;
    }

    private BlockTemplateCompatibilitySerializer() {
    }

    static {
        BlockTemplateCompatibilitySerializer blockTemplateCompatibilitySerializer;
        INSTANCE = blockTemplateCompatibilitySerializer = new BlockTemplateCompatibilitySerializer();
    }
}

