/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.block_templates;

import aurocosh.divinefavor.common.block_templates.BlockTemplate;
import aurocosh.divinefavor.common.block_templates.BlockTemplateSerializer;
import aurocosh.divinefavor.common.lib.BlockMapIntState;
import aurocosh.divinefavor.common.lib.extensions.NbtTagExtensionsKt;
import aurocosh.divinefavor.common.lib.interfaces.INbtWriter;
import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002J \u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Laurocosh/divinefavor/common/block_templates/BlockTemplateSerializer;", "Laurocosh/divinefavor/common/lib/interfaces/INbtWriter;", "Laurocosh/divinefavor/common/block_templates/BlockTemplate;", "()V", "tagCreator", "", "tagDimension", "tagLowerCorner", "tagMapIntStack", "tagMapIntState", "tagPosIntArray", "tagStateIntArray", "tagUUID", "tagUpperCorner", "deserialize", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "nbt", "tag", "serialize", "template", "", "instance", "divinefavor"})
public final class BlockTemplateSerializer
implements INbtWriter<BlockTemplate> {
    private static final String tagUUID = "UUID";
    private static final String tagMapIntState = "mapIntState";
    private static final String tagMapIntStack = "mapIntStack";
    private static final String tagPosIntArray = "posIntArray";
    private static final String tagStateIntArray = "stateIntArray";
    private static final String tagLowerCorner = "lowerCorner";
    private static final String tagUpperCorner = "upperCorner";
    private static final String tagDimension = "dimension";
    private static final String tagCreator = "creator";
    public static final BlockTemplateSerializer INSTANCE;

    @Override
    public void serialize(@NotNull NBTTagCompound nbt, @NotNull String tag, @NotNull BlockTemplate instance) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        nbt.func_74782_a(tag, (NBTBase)this.serialize(instance));
    }

    @Override
    @NotNull
    public BlockTemplate deserialize(@NotNull NBTTagCompound nbt, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagCompound nBTTagCompound = nbt.func_74775_l(tag);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"nbt.getCompoundTag(tag)");
        return this.deserialize(nBTTagCompound);
    }

    @NotNull
    public final NBTTagCompound serialize(@NotNull BlockTemplate template) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_186854_a(tagUUID, template.getUuid());
        NbtTagExtensionsKt.setMap$default(compound, tagMapIntState, template.getBlockMapIntState().getIntStateMap(), serialize.1.INSTANCE, serialize.2.INSTANCE, null, null, 48, null);
        NbtTagExtensionsKt.setMap$default(compound, tagMapIntStack, template.getBlockMapIntState().getIntStackMap(), serialize.3.INSTANCE, serialize.4.INSTANCE, null, null, 48, null);
        compound.func_74783_a(tagPosIntArray, template.getPosIntArray());
        compound.func_74783_a(tagStateIntArray, template.getStateIntArray());
        NbtTagExtensionsKt.setBlockPos(compound, tagLowerCorner, template.getBoundingBox().getLowerCorner());
        NbtTagExtensionsKt.setBlockPos(compound, tagUpperCorner, template.getBoundingBox().getUpperCorner());
        compound.func_74768_a(tagDimension, template.getDimension());
        compound.func_74778_a(tagCreator, template.getCreator());
        return compound;
    }

    @NotNull
    public final BlockTemplate deserialize(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        UUID uUID = compound.func_186857_a(tagUUID);
        if (uUID == null) {
            uUID = UUID.randomUUID();
        }
        UUID uuid = uUID;
        Map intStateMap2 = NbtTagExtensionsKt.getMap$default(compound, tagMapIntState, deserialize.intStateMap.1.INSTANCE, deserialize.intStateMap.2.INSTANCE, null, null, 24, null);
        Map intStackMap2 = NbtTagExtensionsKt.getMap$default(compound, tagMapIntStack, deserialize.intStackMap.1.INSTANCE, deserialize.intStackMap.2.INSTANCE, null, null, 24, null);
        int[] posIntArray = compound.func_74759_k(tagPosIntArray);
        int[] stateIntArray = compound.func_74759_k(tagStateIntArray);
        BlockMapIntState blockMapIntState = new BlockMapIntState(intStateMap2, intStackMap2);
        BlockPos lowerCorner = NbtTagExtensionsKt.getBlockPos(compound, tagLowerCorner);
        BlockPos upperCorner = NbtTagExtensionsKt.getBlockPos(compound, tagUpperCorner);
        int dimension = compound.func_74762_e(tagDimension);
        String creator = compound.func_74779_i(tagCreator);
        UUID uUID2 = uuid;
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"uuid");
        Intrinsics.checkExpressionValueIsNotNull((Object)posIntArray, (String)tagPosIntArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)stateIntArray, (String)tagStateIntArray);
        CuboidBoundingBox cuboidBoundingBox = new CuboidBoundingBox(lowerCorner, upperCorner);
        String string = creator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)tagCreator);
        return new BlockTemplate(uUID2, blockMapIntState, posIntArray, stateIntArray, cuboidBoundingBox, dimension, string, null, 128, null);
    }

    private BlockTemplateSerializer() {
    }

    static {
        BlockTemplateSerializer blockTemplateSerializer;
        INSTANCE = blockTemplateSerializer = new BlockTemplateSerializer();
    }
}

