/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.config.common;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class PatternList {
    private final ImmutableList<Pattern> patterns;

    @Nonnull
    public static String getName(IForgeRegistryEntry<?> entry) {
        ResourceLocation name = entry.getRegistryName();
        if (name == null) {
            throw new IllegalArgumentException("A registry name for the following IForgeRegistryEntry (" + entry.getClass().getName() + ") could not be found: " + entry);
        }
        return name.toString();
    }

    @Nonnull
    static String[] getNames(IForgeRegistryEntry<?> ... blocks) {
        return (String[])Stream.of(blocks).map(PatternList::getName).toArray(String[]::new);
    }

    public static PatternList ofResourcePattern(String ... regex) {
        return PatternList.of(Stream.of(regex), true);
    }

    public static PatternList ofResourcePattern(Collection<String> regex) {
        return PatternList.of(regex.stream(), true);
    }

    public static PatternList of(Stream<String> strings, boolean convertToResourceLocations) {
        if (convertToResourceLocations) {
            strings = strings.map(ResourceLocation::new).map(ResourceLocation::toString);
        }
        return new PatternList((ImmutableList<Pattern>)((ImmutableList)strings.map(Pattern::compile).collect(ImmutableList.toImmutableList())));
    }

    private PatternList(ImmutableList<Pattern> patterns) {
        this.patterns = patterns;
    }

    public boolean containsOre(ItemStack stack2) {
        return !stack2.func_190926_b() && (this.contains((IForgeRegistryEntry<?>)stack2.func_77973_b()) || IntStream.of(OreDictionary.getOreIDs((ItemStack)stack2)).mapToObj(OreDictionary::getOreName).anyMatch(this::contains));
    }

    public boolean contains(IForgeRegistryEntry<?> object) {
        return this.contains(PatternList.getName(object));
    }

    public boolean contains(String s) {
        return this.patterns.stream().anyMatch(p -> p.matcher(s).matches());
    }

    public String[] toArray() {
        return (String[])this.patterns.stream().map(Pattern::toString).toArray(String[]::new);
    }
}

