/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.core.handlers;

import aurocosh.divinefavor.common.custom_data.player.data.interaction_handler.InteractionData;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Laurocosh/divinefavor/common/core/handlers/BlockClickTracker;", "", "()V", "onPlayerLeftClickBlock", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent$LeftClickBlock;", "wasBlockLeftClicked", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "pos", "Lnet/minecraft/util/math/BlockPos;", "divinefavor"})
public final class BlockClickTracker {
    public static final BlockClickTracker INSTANCE;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onPlayerLeftClickBlock(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer entityPlayer = player = event.getEntityPlayer();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"player");
        InteractionData interactionData = PlayerExtensionsKt.getDivinePlayerData(entityPlayer).getInteractionData();
        BlockPos blockPos2 = event.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"event.pos");
        interactionData.recordLastClickedPosition(blockPos2);
    }

    public final boolean wasBlockLeftClicked(@NotNull EntityPlayer player, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        InteractionData interactionData = PlayerExtensionsKt.getDivinePlayerData(player).getInteractionData();
        return interactionData.wasPositionClicked(pos2);
    }

    private BlockClickTracker() {
    }

    static {
        BlockClickTracker blockClickTracker;
        INSTANCE = blockClickTracker = new BlockClickTracker();
    }
}

