/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.player;

import aurocosh.divinefavor.common.custom_data.player.capability.IPlayerDataHandler;
import aurocosh.divinefavor.common.custom_data.player.capability.PlayerDataProvider;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Laurocosh/divinefavor/common/custom_data/player/DeathDataCloner;", "", "()V", "clonePlayer", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "divinefavor"})
public final class DeathDataCloner {
    public static final DeathDataCloner INSTANCE;

    @SubscribeEvent
    public final void clonePlayer(@NotNull PlayerEvent.Clone event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.original");
        IPlayerDataHandler originalData = PlayerExtensionsKt.getDivinePlayerData(entityPlayer);
        EntityPlayer entityPlayer2 = event.getEntityPlayer();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer2, (String)"event.entityPlayer");
        IPlayerDataHandler cloneData = PlayerExtensionsKt.getDivinePlayerData(entityPlayer2);
        if (!event.isWasDeath()) {
            NBTTagCompound serialized = PlayerDataProvider.Companion.serializeNBT(originalData);
            PlayerDataProvider.Companion.deserializeNBT(cloneData, serialized);
        } else {
            cloneData.getSpiritData().deserializeContracts(originalData.getSpiritData().serializeContracts());
            cloneData.getSpiritData().setFavorValues(originalData.getSpiritData().getFavorValues());
            cloneData.getGrudgeData().setMobTypeId(originalData.getGrudgeData().getMobTypeId());
            cloneData.getInteractionData().setLastClickedPositions(originalData.getInteractionData().getLastClickedPositions());
            cloneData.getPearlCrumbsData().setAllPositions(originalData.getPearlCrumbsData().getAllPositions());
        }
    }

    private DeathDataCloner() {
    }

    static {
        DeathDataCloner deathDataCloner;
        INSTANCE = deathDataCloner = new DeathDataCloner();
    }
}

