/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.player;

import aurocosh.divinefavor.common.custom_data.living.capability.ILivingDataHandler;
import aurocosh.divinefavor.common.custom_data.player.capability.IPlayerDataHandler;
import aurocosh.divinefavor.common.lib.extensions.LivingBaseExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.network.message.client.spirit_data.MessageSyncAllSpiritData;
import aurocosh.divinefavor.common.network.message.client.syncing.MessageSyncFury;
import aurocosh.divinefavor.common.network.message.client.syncing.MessageSyncGrudge;
import aurocosh.divinefavor.common.network.message.client.syncing.MessageSyncTemplateClient;
import aurocosh.divinefavor.common.network.message.client.syncing.MessageSyncWindLeash;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Laurocosh/divinefavor/common/custom_data/player/LoginDataSyncer;", "", "()V", "onPlayerChangedDimension", "", "event", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerLogin", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerLoggedInEvent;", "syncData", "eventPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "divinefavor"})
public final class LoginDataSyncer {
    public static final LoginDataSyncer INSTANCE;

    @SubscribeEvent
    public final void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        this.syncData(entityPlayer);
    }

    @SubscribeEvent
    public final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        this.syncData(entityPlayer);
    }

    @SubscribeEvent
    public final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        this.syncData(entityPlayer);
    }

    private final void syncData(EntityPlayer eventPlayer) {
        EntityPlayer entityPlayer = eventPlayer;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            entityPlayer = null;
        }
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityPlayer;
        if (entityPlayerMP == null) {
            return;
        }
        EntityPlayerMP player = entityPlayerMP;
        IPlayerDataHandler handler = PlayerExtensionsKt.getDivinePlayerData((EntityPlayer)player);
        new MessageSyncAllSpiritData(handler.getSpiritData()).sendTo((EntityPlayer)player);
        new MessageSyncFury(handler.getFocusedFuryData().getMobTypeId()).sendTo((EntityPlayer)player);
        new MessageSyncGrudge(handler.getGrudgeData().getMobTypeId()).sendTo((EntityPlayer)player);
        new MessageSyncTemplateClient(handler.getTemplateData().getCurrentTemplate()).sendTo((EntityPlayer)player);
        ILivingDataHandler livingDataHandler = LivingBaseExtensionsKt.getDivineLivingData((EntityLivingBase)player);
        new MessageSyncWindLeash(livingDataHandler.getWindLeashData().getVector()).sendTo((EntityPlayer)player);
    }

    private LoginDataSyncer() {
    }

    static {
        LoginDataSyncer loginDataSyncer;
        INSTANCE = loginDataSyncer = new LoginDataSyncer();
    }
}

