/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.player.data.curse.corrosion;

import aurocosh.divinefavor.common.config.common.ConfigCurses;
import aurocosh.divinefavor.common.lib.LoopedCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005R0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Laurocosh/divinefavor/common/custom_data/player/data/curse/corrosion/ArmorCorrosionData;", "", "()V", "slots", "", "", "corrodedArmorSlots", "getCorrodedArmorSlots", "()Ljava/util/List;", "setCorrodedArmorSlots", "(Ljava/util/List;)V", "corrodedSlots", "", "isCorrosionNeeded", "", "()Z", "loopedCounter", "Laurocosh/divinefavor/common/lib/LoopedCounter;", "addCorrosionToArmorSlot", "", "slot", "nothingToCorrode", "removeAllCorrosion", "removeCorrosionFromArmorSlot", "divinefavor"})
public final class ArmorCorrosionData {
    private final List<Integer> corrodedSlots = new ArrayList();
    private final LoopedCounter loopedCounter;

    @NotNull
    public final List<Integer> getCorrodedArmorSlots() {
        List<Integer> list2 = Collections.unmodifiableList(this.corrodedSlots);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(corrodedSlots)");
        return list2;
    }

    public final void setCorrodedArmorSlots(@NotNull List<Integer> slots) {
        Intrinsics.checkParameterIsNotNull(slots, (String)"slots");
        this.corrodedSlots.clear();
        this.corrodedSlots.addAll((Collection<Integer>)slots);
    }

    public final boolean isCorrosionNeeded() {
        return this.loopedCounter.tick();
    }

    public final void removeAllCorrosion() {
        this.corrodedSlots.clear();
    }

    public final void addCorrosionToArmorSlot(int slot) {
        int n = slot;
        int n2 = n = 1 <= n && 2 >= n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterator<Integer> iterator = this.corrodedSlots.iterator();
        while (iterator.hasNext()) {
            int corrodedSlot = ((Number)iterator.next()).intValue();
            if (corrodedSlot != slot) continue;
            return;
        }
        this.corrodedSlots.add(slot);
    }

    public final void removeCorrosionFromArmorSlot(int slot) {
        this.corrodedSlots.remove((Object)slot);
    }

    public final boolean nothingToCorrode() {
        return this.corrodedSlots.size() == 0;
    }

    public ArmorCorrosionData() {
        this.loopedCounter = new LoopedCounter(ConfigCurses.armorCorrosion.corrosionRate);
    }
}

