/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.player.data.favor;

import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.lib.interfaces.INbtSerializer;
import aurocosh.divinefavor.common.registry.mappers.ModMappers;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritDataSerializer;", "Laurocosh/divinefavor/common/lib/interfaces/INbtSerializer;", "Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritData;", "()V", "deserialize", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "instance", "serialize", "Companion", "divinefavor"})
public final class SpiritDataSerializer
implements INbtSerializer<SpiritData> {
    private static final String TAG_SPIRIT_DATA = "SpiritData";
    private static final String TAG_CONTRACTS = "Contracts";
    private static final String TAG_FAVOR_VALUES = "FavorValues";
    private static final String TAG_FAVOR_INFINITE = "FavorInfinite";
    public static final Companion Companion = new Companion(null);

    @Override
    public void serialize(@NotNull NBTTagCompound nbt, @NotNull SpiritData instance) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(TAG_FAVOR_VALUES, (NBTBase)Companion.getFavorTag(instance));
        tag.func_74782_a(TAG_FAVOR_INFINITE, (NBTBase)Companion.getInfinityTag(instance));
        tag.func_74782_a(TAG_CONTRACTS, (NBTBase)instance.serializeContracts());
        nbt.func_74782_a(TAG_SPIRIT_DATA, (NBTBase)tag);
    }

    @Override
    public void deserialize(@NotNull NBTTagCompound nbt, @NotNull SpiritData instance) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        if (!nbt.func_74764_b(TAG_SPIRIT_DATA)) {
            return;
        }
        NBTTagCompound spiritTag = nbt.func_74775_l(TAG_SPIRIT_DATA);
        if (spiritTag.func_74764_b(TAG_CONTRACTS)) {
            NBTTagCompound nBTTagCompound = spiritTag.func_74775_l(TAG_CONTRACTS);
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"spiritTag.getCompoundTag(TAG_CONTRACTS)");
            instance.deserializeContracts(nBTTagCompound);
        }
        NBTTagCompound nBTTagCompound = spiritTag.func_74775_l(TAG_FAVOR_VALUES);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"spiritTag.getCompoundTag(TAG_FAVOR_VALUES)");
        Companion.setFavorFromTag(nBTTagCompound, instance);
        NBTTagCompound nBTTagCompound2 = spiritTag.func_74775_l(TAG_FAVOR_INFINITE);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"spiritTag.getCompoundTag(TAG_FAVOR_INFINITE)");
        Companion.setInfinityFromTag(nBTTagCompound2, instance);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritDataSerializer$Companion;", "", "()V", "TAG_CONTRACTS", "", "TAG_FAVOR_INFINITE", "TAG_FAVOR_VALUES", "TAG_SPIRIT_DATA", "getFavorTag", "Lnet/minecraft/nbt/NBTTagCompound;", "instance", "Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritData;", "getInfinityTag", "setFavorFromTag", "", "nbt", "setInfinityFromTag", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final NBTTagCompound getFavorTag(@NotNull SpiritData instance) {
            Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
            NBTTagCompound tag = new NBTTagCompound();
            for (ModSpirit spirit : ModMappers.INSTANCE.getSpirits().getValues()) {
                tag.func_74768_a(spirit.getName(), instance.getFavor(spirit.getId()));
            }
            return tag;
        }

        public final void setFavorFromTag(@NotNull NBTTagCompound nbt, @NotNull SpiritData instance) {
            Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
            Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
            for (ModSpirit spirit : ModMappers.INSTANCE.getSpirits().getValues()) {
                instance.setFavor(spirit.getId(), nbt.func_74762_e(spirit.getName()));
            }
        }

        @NotNull
        public final NBTTagCompound getInfinityTag(@NotNull SpiritData instance) {
            Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
            NBTTagCompound tag = new NBTTagCompound();
            for (ModSpirit spirit : ModMappers.INSTANCE.getSpirits().getValues()) {
                tag.func_74757_a(spirit.getName(), instance.isFavorInfinite(spirit.getId()));
            }
            return tag;
        }

        public final void setInfinityFromTag(@NotNull NBTTagCompound nbt, @NotNull SpiritData instance) {
            Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
            Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
            for (ModSpirit spirit : ModMappers.INSTANCE.getSpirits().getValues()) {
                instance.setFavorInfinite(spirit.getId(), nbt.func_74767_n(spirit.getName()));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

