/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.world.data.altars;

import aurocosh.divinefavor.common.custom_data.world.data.altars.AltarsData;
import aurocosh.divinefavor.common.registry.mappers.ModMappers;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007RH\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Laurocosh/divinefavor/common/custom_data/world/data/altars/AltarsData;", "", "()V", "positions", "", "", "", "Lnet/minecraft/util/math/BlockPos;", "allPositions", "getAllPositions", "()Ljava/util/Map;", "setAllPositions", "(Ljava/util/Map;)V", "", "positionsInverse", "addAltarLocation", "", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "pos", "getAltarLocations", "", "getAltars", "spiritId", "removeAltarLocation", "divinefavor"})
public final class AltarsData {
    private final Map<Integer, Set<BlockPos>> positions = new HashMap();
    private final Map<BlockPos, Integer> positionsInverse = new HashMap();

    @NotNull
    public final Map<Integer, Set<BlockPos>> getAllPositions() {
        return new HashMap<Integer, Set<BlockPos>>(this.positions);
    }

    public final void setAllPositions(@NotNull Map<Integer, ? extends Set<BlockPos>> positions2) {
        Intrinsics.checkParameterIsNotNull(positions2, (String)"positions");
        this.positions.clear();
        this.positions.putAll(positions2);
    }

    public final void addAltarLocation(@NotNull ModSpirit spirit, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (this.positionsInverse.containsKey(pos2)) {
            this.removeAltarLocation(spirit, pos2);
        }
        Set<BlockPos> altars = this.getAltars(spirit.getId());
        Map<BlockPos, Integer> map2 = this.positionsInverse;
        Integer n = spirit.getId();
        map2.put(pos2, n);
        altars.add(pos2);
    }

    public final void removeAltarLocation(@NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Integer n = this.positionsInverse.get(pos2);
        if (n == null) {
            return;
        }
        int spiritId = n;
        ModSpirit spirit = ModMappers.INSTANCE.getSpirits().get(spiritId);
        this.removeAltarLocation(spirit, pos2);
    }

    public final void removeAltarLocation(@NotNull ModSpirit spirit, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Set<BlockPos> altars = this.getAltars(spirit.getId());
        this.positionsInverse.remove(pos2);
        altars.remove(pos2);
    }

    private final Set<BlockPos> getAltars(int spiritId) {
        Set<BlockPos> set = this.positions.computeIfAbsent(spiritId, getAltars.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"positions.computeIfAbsen\u2026 { integer -> HashSet() }");
        return set;
    }

    @NotNull
    public final Set<BlockPos> getAltarLocations(@NotNull ModSpirit spirit) {
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        Set<BlockPos> set = Collections.unmodifiableSet(this.getAltars(spirit.getId()));
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(getAltars(spirit.id))");
        return set;
    }
}

