/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.custom_data.world.data.altars;

import aurocosh.divinefavor.common.custom_data.world.data.altars.AltarsData;
import aurocosh.divinefavor.common.lib.interfaces.INbtSerializer;
import aurocosh.divinefavor.common.registry.mappers.ModMappers;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.util.UtilBlockPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Laurocosh/divinefavor/common/custom_data/world/data/altars/AltarsDataSerializer;", "Laurocosh/divinefavor/common/lib/interfaces/INbtSerializer;", "Laurocosh/divinefavor/common/custom_data/world/data/altars/AltarsData;", "()V", "deserialize", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "instance", "serialize", "Companion", "divinefavor"})
public final class AltarsDataSerializer
implements INbtSerializer<AltarsData> {
    private static final String TAG_ALTAR_POSITIONS = "AltarPositions";
    public static final Companion Companion = new Companion(null);

    @Override
    public void serialize(@NotNull NBTTagCompound nbt, @NotNull AltarsData instance) {
        Map<Integer, Set<BlockPos>> positions2;
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        NBTTagCompound altarNbt = new NBTTagCompound();
        Map<Integer, Set<BlockPos>> map2 = positions2 = instance.getAllPositions();
        Iterator<Map.Entry<Integer, Set<BlockPos>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Set<BlockPos>> entry;
            Map.Entry<Integer, Set<BlockPos>> entry2 = entry = iterator.next();
            int spiritId = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            Set<BlockPos> value = entry2.getValue();
            ArrayList altarLocations = new ArrayList(value);
            ModSpirit spirit = ModMappers.INSTANCE.getSpirits().get(spiritId);
            int[] posArray = UtilBlockPos.INSTANCE.serialize(altarLocations);
            altarNbt.func_74783_a(spirit.getName(), posArray);
        }
        nbt.func_74782_a(TAG_ALTAR_POSITIONS, (NBTBase)altarNbt);
    }

    @Override
    public void deserialize(@NotNull NBTTagCompound nbt, @NotNull AltarsData instance) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        if (!nbt.func_74764_b(TAG_ALTAR_POSITIONS)) {
            return;
        }
        NBTTagCompound altarNbt = nbt.func_74775_l(TAG_ALTAR_POSITIONS);
        List<ModSpirit> spirits = ModMappers.INSTANCE.getSpirits().getValues();
        HashMap positions2 = new HashMap();
        for (ModSpirit spirit : spirits) {
            String spiritName = spirit.getName();
            if (!altarNbt.func_74764_b(spiritName)) {
                return;
            }
            int[] posArray = altarNbt.func_74759_k(spiritName);
            Intrinsics.checkExpressionValueIsNotNull((Object)posArray, (String)"posArray");
            ArrayList<BlockPos> altarLocations = UtilBlockPos.INSTANCE.deserialize(posArray);
            Map map2 = positions2;
            Integer n = spirit.getId();
            HashSet hashSet = new HashSet(altarLocations);
            map2.put(n, hashSet);
        }
        instance.setAllPositions(positions2);
    }

    static {
        TAG_ALTAR_POSITIONS = TAG_ALTAR_POSITIONS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Laurocosh/divinefavor/common/custom_data/world/data/altars/AltarsDataSerializer$Companion;", "", "()V", "TAG_ALTAR_POSITIONS", "", "divinefavor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

