/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.entity.ai;

import aurocosh.divinefavor.common.entity.minions.base.IMinion;
import aurocosh.divinefavor.common.entity.minions.base.MinionMode;
import aurocosh.divinefavor.common.util.UtilCoordinates;
import aurocosh.divinefavor.common.util.UtilEntity;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 %*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004:\u0001%B;\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0006\u0010#\u001a\u00020\u001eJ\b\u0010$\u001a\u00020\u001eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Laurocosh/divinefavor/common/entity/ai/EntityAIFollowOwner;", "T", "Laurocosh/divinefavor/common/entity/minions/base/IMinion;", "Lnet/minecraft/entity/EntityLiving;", "Lnet/minecraft/entity/ai/EntityAIBase;", "minion", "followSpeed", "", "minDist", "", "maxDist", "teleportIfTooFar", "", "shouldFollow", "Lkotlin/Function0;", "(Lnet/minecraft/entity/EntityLiving;DFFZLkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/entity/EntityLiving;", "oldWaterCost", "owner", "Lnet/minecraft/entity/EntityLivingBase;", "petPathfinder", "Lnet/minecraft/pathfinding/PathNavigate;", "timeToRecalcPath", "", "world", "Lnet/minecraft/world/World;", "isEmptyBlock", "pos", "Lnet/minecraft/util/math/BlockPos;", "resetTask", "", "safeTeleport", "shouldContinueExecuting", "shouldExecute", "startExecuting", "tryToTelepotToOwner", "updateTask", "Companion", "divinefavor"})
public final class EntityAIFollowOwner<T extends EntityLiving>
extends EntityAIBase {
    private final PathNavigate petPathfinder;
    private EntityLivingBase owner;
    private final World world;
    private float oldWaterCost;
    private int timeToRecalcPath;
    private final T minion;
    private final double followSpeed;
    private final float minDist;
    private final float maxDist;
    private final boolean teleportIfTooFar;
    private final Function0<Boolean> shouldFollow;
    private static final int TeleportAttempts = 4;
    private static final int TeleportRadius = 4;
    public static final Companion Companion = new Companion(null);

    public boolean func_75250_a() {
        EntityPlayer livingBase = ((IMinion)this.minion).getMinionData().getOwner();
        if (livingBase == null) {
            return false;
        }
        if (livingBase.func_175149_v()) {
            return false;
        }
        if (this.minion.func_70068_e((Entity)livingBase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        if (!((Boolean)this.shouldFollow.invoke()).booleanValue()) {
            return false;
        }
        this.owner = (EntityLivingBase)livingBase;
        return true;
    }

    public boolean func_75253_b() {
        if (this.owner == null) {
            return false;
        }
        return !this.petPathfinder.func_75500_f() && this.minion.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && (Boolean)this.shouldFollow.invoke() != false;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.minion.func_184643_a(PathNodeType.WATER);
        this.minion.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.minion.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    private final boolean isEmptyBlock(BlockPos pos2) {
        IBlockState state2;
        IBlockState iBlockState = state2 = this.world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return iBlockState.func_185904_a() == Material.field_151579_a || !state2.func_185917_h();
    }

    public void func_75246_d() {
        EntityLivingBase entityLivingBase = this.owner;
        if (entityLivingBase == null) {
            return;
        }
        EntityLivingBase owner = entityLivingBase;
        this.minion.func_70671_ap().func_75651_a((Entity)owner, 10.0f, (float)this.minion.func_70646_bf());
        if (((IMinion)this.minion).getMinionData().getMode() == MinionMode.Wait) {
            return;
        }
        EntityAIFollowOwner entityAIFollowOwner = this;
        entityAIFollowOwner.timeToRecalcPath += -1;
        if (entityAIFollowOwner.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)owner, this.followSpeed) && this.teleportIfTooFar) {
                this.tryToTelepotToOwner();
            }
        }
    }

    public final void tryToTelepotToOwner() {
        EntityLivingBase entityLivingBase = this.owner;
        if (entityLivingBase == null) {
            return;
        }
        EntityLivingBase owner = entityLivingBase;
        if (this.minion.func_110167_bD()) {
            return;
        }
        if (this.minion.func_70068_e((Entity)owner) < 144.0) {
            return;
        }
        boolean teleported = false;
        int attempts = 4;
        while (!teleported && attempts-- > 0) {
            BlockPos blockPos2 = owner.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"owner.position");
            BlockPos pos2 = UtilCoordinates.INSTANCE.getRandomNeighbour(blockPos2, 4, 0, 4);
            teleported = this.safeTeleport(pos2);
            if (teleported) continue;
            World world = ((EntityLiving)this.minion).field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"minion.world");
            BlockPos blockPos3 = UtilCoordinates.INSTANCE.findPlaceToStand(pos2, world, 4);
            if (blockPos3 == null) {
                return;
            }
            pos2 = blockPos3;
            teleported = this.safeTeleport(pos2);
        }
        this.petPathfinder.func_75499_g();
    }

    private final boolean safeTeleport(BlockPos pos2) {
        if (!this.isEmptyBlock(pos2)) {
            return false;
        }
        UtilEntity.INSTANCE.teleport((EntityLivingBase)this.minion, pos2);
        return true;
    }

    public EntityAIFollowOwner(@NotNull T minion, double followSpeed, float minDist, float maxDist, boolean teleportIfTooFar, @NotNull Function0<Boolean> shouldFollow) {
        Intrinsics.checkParameterIsNotNull(minion, (String)"minion");
        Intrinsics.checkParameterIsNotNull(shouldFollow, (String)"shouldFollow");
        this.minion = minion;
        this.followSpeed = followSpeed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportIfTooFar = teleportIfTooFar;
        this.shouldFollow = shouldFollow;
        PathNavigate pathNavigate = this.minion.func_70661_as();
        Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"minion.navigator");
        this.petPathfinder = pathNavigate;
        World world = ((EntityLiving)this.minion).field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"minion.world");
        this.world = world;
        this.func_75248_a(3);
        if (!(this.minion.func_70661_as() instanceof PathNavigateGround)) {
            throw (Throwable)new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Laurocosh/divinefavor/common/entity/ai/EntityAIFollowOwner$Companion;", "", "()V", "TeleportAttempts", "", "TeleportRadius", "divinefavor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

