/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.entity.minions.base;

import aurocosh.divinefavor.common.entity.minions.base.IMinion;
import aurocosh.divinefavor.common.entity.minions.base.MinionMode;
import com.google.common.base.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 >*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004:\u0001>BE\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\t\u00a2\u0006\u0002\u0010\u0010J\u0006\u00101\u001a\u00020\nJ\u000e\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002052\u0006\u0010,\u001a\u000209J\u0010\u0010:\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010<J\u000e\u0010=\u001a\u0002052\u0006\u00106\u001a\u000207R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR&\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010&\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R(\u0010,\u001a\u0004\u0018\u00010\u000f2\b\u0010,\u001a\u0004\u0018\u00010\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Laurocosh/divinefavor/common/entity/minions/base/MinionData;", "T", "Laurocosh/divinefavor/common/entity/minions/base/IMinion;", "Lnet/minecraft/entity/EntityCreature;", "", "minion", "dataManager", "Lnet/minecraft/network/datasync/EntityDataManager;", "beggingParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "modeParameter", "", "ownerUniqueIdParameter", "Lcom/google/common/base/Optional;", "Ljava/util/UUID;", "(Lnet/minecraft/entity/EntityCreature;Lnet/minecraft/network/datasync/EntityDataManager;Lnet/minecraft/network/datasync/DataParameter;Lnet/minecraft/network/datasync/DataParameter;Lnet/minecraft/network/datasync/DataParameter;)V", "attackTarget", "Lnet/minecraft/entity/EntityLivingBase;", "getAttackTarget", "()Lnet/minecraft/entity/EntityLivingBase;", "setAttackTarget", "(Lnet/minecraft/entity/EntityLivingBase;)V", "beg", "isBegging", "()Z", "setBegging", "(Z)V", "isFollowing", "isWaiting", "Lnet/minecraft/entity/EntityCreature;", "value", "Laurocosh/divinefavor/common/entity/minions/base/MinionMode;", "mode", "getMode", "()Laurocosh/divinefavor/common/entity/minions/base/MinionMode;", "setMode", "(Laurocosh/divinefavor/common/entity/minions/base/MinionMode;)V", "owner", "Lnet/minecraft/entity/player/EntityPlayer;", "getOwner", "()Lnet/minecraft/entity/player/EntityPlayer;", "setOwner", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "ownerUUID", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "hasOwner", "isOwner", "entityIn", "readEntityFromNBT", "", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setOwnerByUUID", "", "shouldAttack", "entity", "Lnet/minecraft/entity/EntityLiving;", "writeEntityToNBT", "Companion", "divinefavor"})
public final class MinionData<T extends EntityCreature> {
    @Nullable
    private EntityLivingBase attackTarget;
    @NotNull
    private MinionMode mode;
    private final T minion;
    private final EntityDataManager dataManager;
    private final DataParameter<Boolean> beggingParameter;
    private final DataParameter<Integer> modeParameter;
    private final DataParameter<Optional<UUID>> ownerUniqueIdParameter;
    private static final String TAG_OWNER_UUID = "OwnerUUID";
    private static final String TAG_MODE = "Mode";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public final void setAttackTarget(@Nullable EntityLivingBase entityLivingBase) {
        this.attackTarget = entityLivingBase;
    }

    public final boolean isBegging() {
        Object object = this.dataManager.func_187225_a(this.beggingParameter);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(beggingParameter)");
        return (Boolean)object;
    }

    public final void setBegging(boolean beg) {
        this.dataManager.func_187227_b(this.beggingParameter, (Object)beg);
    }

    @Nullable
    public final UUID getOwnerUUID() {
        Object object = this.dataManager.func_187225_a(this.ownerUniqueIdParameter);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.common.base.Optional<*>");
        }
        return (UUID)((Optional)object).orNull();
    }

    public final void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.dataManager.func_187227_b(this.ownerUniqueIdParameter, (Object)Optional.fromNullable((Object)ownerUUID));
    }

    @Nullable
    public final EntityPlayer getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : ((EntityCreature)this.minion).field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public final void setOwner(@Nullable EntityPlayer owner) {
        EntityPlayer entityPlayer = owner;
        this.setOwnerUUID(entityPlayer != null && (entityPlayer = entityPlayer.func_146103_bH()) != null ? entityPlayer.getId() : null);
    }

    public final boolean isFollowing() {
        return this.getMode() == MinionMode.Follow;
    }

    public final boolean isWaiting() {
        return this.getMode() == MinionMode.Wait;
    }

    @NotNull
    public final MinionMode getMode() {
        Object object = this.dataManager.func_187225_a(this.modeParameter);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(modeParameter)");
        return (MinionMode)MinionMode.Companion.get(((Number)object).intValue());
    }

    public final void setMode(@NotNull MinionMode value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.mode = value;
        this.dataManager.func_187227_b(this.modeParameter, (Object)value.getValue());
    }

    public final boolean hasOwner() {
        Object object = this.dataManager.func_187225_a(this.ownerUniqueIdParameter);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(ownerUniqueIdParameter)");
        return ((Optional)object).isPresent();
    }

    public final boolean isOwner(@NotNull EntityLivingBase entityIn) {
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        return entityIn == this.getOwner();
    }

    public final void setOwnerByUUID(@NotNull String ownerUUID) {
        Intrinsics.checkParameterIsNotNull((Object)ownerUUID, (String)"ownerUUID");
        CharSequence charSequence = ownerUUID;
        MinionData minionData = this;
        boolean bl = charSequence.length() == 0;
        minionData.setOwnerUUID(bl ? null : UUID.fromString(ownerUUID));
    }

    public final void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        UUID ownerId = this.getOwnerUUID();
        Object object = ownerId;
        if (object == null || (object = ((UUID)object).toString()) == null) {
            object = "";
        }
        compound.func_74778_a(TAG_OWNER_UUID, (String)object);
        compound.func_74768_a(TAG_MODE, this.getMode().getValue());
    }

    public final void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        String string = compound.func_74779_i(TAG_OWNER_UUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compound.getString(TAG_OWNER_UUID)");
        this.setOwnerByUUID(string);
        this.setMode((MinionMode)MinionMode.Companion.get(compound.func_74762_e(TAG_MODE)));
    }

    public final boolean shouldAttack(@Nullable EntityLiving entity) {
        IMinion minion;
        EntityPlayer owner = this.getOwner();
        if (entity == owner) {
            return false;
        }
        if (entity instanceof IMinion && (minion = (IMinion)entity).getMinionData().getOwner() == owner) {
            return false;
        }
        EntityLiving entityLiving = entity;
        if (!(entityLiving instanceof EntityLivingBase)) {
            entityLiving = null;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)entityLiving;
        return entityLivingBase != null ? entityLivingBase.func_190631_cK() : false;
    }

    public MinionData(@NotNull T minion, @NotNull EntityDataManager dataManager, @NotNull DataParameter<Boolean> beggingParameter, @NotNull DataParameter<Integer> modeParameter, @NotNull DataParameter<Optional<UUID>> ownerUniqueIdParameter) {
        Intrinsics.checkParameterIsNotNull(minion, (String)"minion");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        Intrinsics.checkParameterIsNotNull(beggingParameter, (String)"beggingParameter");
        Intrinsics.checkParameterIsNotNull(modeParameter, (String)"modeParameter");
        Intrinsics.checkParameterIsNotNull(ownerUniqueIdParameter, (String)"ownerUniqueIdParameter");
        this.minion = minion;
        this.dataManager = dataManager;
        this.beggingParameter = beggingParameter;
        this.modeParameter = modeParameter;
        this.ownerUniqueIdParameter = ownerUniqueIdParameter;
        this.mode = MinionMode.Normal;
    }

    static {
        TAG_OWNER_UUID = TAG_OWNER_UUID;
        TAG_MODE = TAG_MODE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Laurocosh/divinefavor/common/entity/minions/base/MinionData$Companion;", "", "()V", "TAG_MODE", "", "TAG_OWNER_UUID", "divinefavor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

