/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.entity.rope.base;

import aurocosh.divinefavor.common.block.common.ModBlocks;
import aurocosh.divinefavor.common.entity.rope.base.EntityRopeNodeBase;
import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.NbtTagExtensionsKt;
import aurocosh.divinefavor.common.util.UtilEntity;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 b2\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010:\u001a\u00020\u000bH\u0016J\u0010\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0014J\u0006\u0010>\u001a\u00020?J\b\u0010@\u001a\u00020?H\u0002J\u0010\u0010A\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010B\u001a\u00020?H\u0014J&\u0010C\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020EJ\u0012\u0010H\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0000J\b\u0010K\u001a\u00020LH\u0014J\u0010\u0010M\u001a\u00020?2\u0006\u0010N\u001a\u00020\u000bH\u0002J$\u0010O\u001a\u00020?2\u0006\u0010N\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010P\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020EH\u0017J\u0010\u0010R\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H$J\b\u0010S\u001a\u00020?H\u0016J\u0010\u0010T\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0002J\u001c\u0010U\u001a\u00020?2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u0010V\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=2\u0006\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020?2\u0006\u0010Z\u001a\u00020[H\u0014J\u0010\u0010\\\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0014J\u000e\u0010]\u001a\u00020?2\u0006\u0010^\u001a\u00020\u0001J\b\u0010_\u001a\u00020?H\u0016J\u0010\u0010`\u001a\u00020?2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u0010\u0010a\u001a\u00020?2\u0006\u0010Z\u001a\u00020[H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0013\u0010#\u001a\u0004\u0018\u00010\u00018G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0016\u0010%\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR(\u0010)\u001a\u0004\u0018\u00010(2\b\u0010'\u001a\u0004\u0018\u00010(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010/\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001eR\u0013\u00101\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001eR\u0013\u00103\u001a\u0004\u0018\u00010\u00018G\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001eR\u0016\u00105\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001eR(\u00107\u001a\u0004\u0018\u00010(2\b\u0010'\u001a\u0004\u0018\u00010(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-\u00a8\u0006c"}, d2={"Laurocosh/divinefavor/common/entity/rope/base/EntityRopeNodeBase;", "Lnet/minecraft/entity/Entity;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "cachedNextNodeDW", "", "cachedNextNodeEntity", "cachedPrevNodeDW", "cachedPrevNodeEntity", "canExtend", "", "connectionToNext", "Lnet/minecraft/util/math/Vec3d;", "getConnectionToNext", "()Lnet/minecraft/util/math/Vec3d;", "despawnTimer", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "isAttached", "()Z", "isEmittingLight", "isMobile", "lightBlock", "Lnet/minecraft/util/math/BlockPos;", "entity", "nextNode", "getNextNode", "()Lnet/minecraft/entity/Entity;", "setNextNode", "(Lnet/minecraft/entity/Entity;)V", "nextNodeByUUID", "getNextNodeByUUID", "nextNodeClient", "getNextNodeClient", "nextNodeServer", "getNextNodeServer", "uuid", "Ljava/util/UUID;", "nextNodeUUID", "getNextNodeUUID", "()Ljava/util/UUID;", "setNextNodeUUID", "(Ljava/util/UUID;)V", "pickUp", "prevNode", "getPrevNode", "previousNodeByUUID", "getPreviousNodeByUUID", "previousNodeClient", "getPreviousNodeClient", "previousNodeServer", "getPreviousNodeServer", "previousNodeUUID", "getPreviousNodeUUID", "setPreviousNodeUUID", "canBeCollidedWith", "canDropNewNode", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "despawn", "", "destroyLightSource", "dropNewNode", "entityInit", "extendRope", "x", "", "y", "z", "getEntityByUUID", "getLastConnectedNode", "endNode", "getLightBlock", "Lnet/minecraft/block/Block;", "handleLightBlocks", "attached", "handleRopeMovement", "isInRangeToRenderDist", "distance", "makeNewNode", "onEntityUpdate", "pickUpThisNode", "processDespawn", "processInitialInteract", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "registerPickUp", "removeNode", "nextConnectionNode", "setDead", "setPreviousNode", "writeEntityToNBT", "Companion", "divinefavor"})
public abstract class EntityRopeNodeBase
extends Entity {
    private boolean canExtend;
    private boolean pickUp;
    private int despawnTimer;
    @Nullable
    private UUID nextNodeUUID;
    @Nullable
    private UUID previousNodeUUID;
    private int cachedPrevNodeDW;
    private int cachedNextNodeDW;
    private Entity cachedNextNodeEntity;
    private Entity cachedPrevNodeEntity;
    private BlockPos lightBlock;
    private static final DataParameter<Integer> DW_PREV_NODE;
    private static final DataParameter<Integer> DW_NEXT_NODE;
    private static final double ROPE_LENGTH = 4.0;
    private static final double ROPE_LENGTH_SQ = 16.0;
    private static final double ROPE_LENGTH_MAX = 12.0;
    private static final String TAG_NEXT_NODE_UUID = "nextNodeUUID";
    private static final String TAG_PREVIOUS_NODE_UUID = "previousNodeUUID";
    private static final String TAG_PICK_UP = "pickUp";
    private static final String TAG_CAN_EXTEND = "canExtend";
    private static final String TAG_DESPAWN_TIMER = "despawnTimer";
    private static final String TAG_LIGHT_BLOCK = "lightBlock";
    public static final Companion Companion;

    @Nullable
    public final UUID getNextNodeUUID() {
        return this.nextNodeUUID;
    }

    public final void setNextNodeUUID(@Nullable UUID uuid) {
        this.nextNodeUUID = uuid;
        if (this.cachedNextNodeEntity != null) {
            Entity entity = this.cachedNextNodeEntity;
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)entity.func_110124_au(), (Object)uuid) ^ true) {
                this.cachedNextNodeEntity = null;
            }
        }
    }

    @Nullable
    public final UUID getPreviousNodeUUID() {
        return this.previousNodeUUID;
    }

    public final void setPreviousNodeUUID(@Nullable UUID uuid) {
        this.previousNodeUUID = uuid;
        if (this.cachedPrevNodeEntity != null) {
            Entity entity = this.cachedPrevNodeEntity;
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)entity.func_110124_au(), (Object)uuid) ^ true) {
                this.cachedPrevNodeEntity = null;
            }
        }
    }

    public final boolean isAttached() {
        return !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1)).isEmpty();
    }

    @NotNull
    protected abstract Class<? extends EntityRopeNodeBase> getEntityClass();

    protected boolean isEmittingLight() {
        return false;
    }

    protected boolean isMobile() {
        return true;
    }

    @Nullable
    public final Vec3d getConnectionToNext() {
        Entity nextNode = this.field_70170_p.field_72995_K ? this.getNextNodeClient() : this.getNextNodeByUUID();
        return nextNode != null ? new Vec3d(nextNode.field_70165_t - this.field_70165_t, nextNode.field_70163_u - this.field_70163_u, nextNode.field_70161_v - this.field_70161_v) : null;
    }

    @Nullable
    public final Entity getNextNodeByUUID() {
        UUID uuid;
        Entity entity;
        if (this.cachedNextNodeEntity != null) {
            Entity entity2 = this.cachedNextNodeEntity;
            if (entity2 == null) {
                Intrinsics.throwNpe();
            }
            if (entity2.func_70089_S()) {
                Entity entity3 = this.cachedNextNodeEntity;
                if (entity3 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)entity3.func_110124_au(), (Object)this.nextNodeUUID)) {
                    return this.cachedNextNodeEntity;
                }
            }
        }
        this.cachedNextNodeEntity = entity = (uuid = this.nextNodeUUID) == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    @Nullable
    public final Entity getPreviousNodeByUUID() {
        UUID uuid;
        Entity entity;
        if (this.cachedPrevNodeEntity != null) {
            Entity entity2 = this.cachedPrevNodeEntity;
            if (entity2 == null) {
                Intrinsics.throwNpe();
            }
            if (entity2.func_70089_S()) {
                Entity entity3 = this.cachedPrevNodeEntity;
                if (entity3 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)entity3.func_110124_au(), (Object)this.previousNodeUUID)) {
                    return this.cachedPrevNodeEntity;
                }
            }
        }
        this.cachedPrevNodeEntity = entity = (uuid = this.previousNodeUUID) == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    @Nullable
    public final Entity getPrevNode() {
        return this.field_70170_p.field_72995_K ? this.getPreviousNodeClient() : this.getPreviousNodeServer();
    }

    @Nullable
    public final Entity getNextNode() {
        return this.field_70170_p.field_72995_K ? this.getNextNodeClient() : this.getNextNodeServer();
    }

    public final void setNextNode(@Nullable Entity entity) {
        this.cachedNextNodeEntity = entity;
        Entity entity2 = entity;
        this.setNextNodeUUID(entity2 != null ? entity2.func_110124_au() : null);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public final Entity getNextNodeClient() {
        block6: {
            Entity entity;
            block5: {
                if (this.cachedNextNodeEntity == null) break block5;
                Entity entity2 = this.cachedNextNodeEntity;
                if (entity2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!entity2.func_70089_S()) break block5;
                Entity entity3 = this.cachedNextNodeEntity;
                if (entity3 == null) {
                    Intrinsics.throwNpe();
                }
                Integer n = (Integer)this.func_184212_Q().func_187225_a(DW_NEXT_NODE);
                if (n != null && entity3.func_145782_y() == n.intValue()) break block6;
            }
            Object object = this.func_184212_Q().func_187225_a(DW_NEXT_NODE);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getDataManager().get(DW_NEXT_NODE)");
            this.cachedNextNodeEntity = entity = this.field_70170_p.func_73045_a(((Number)object).intValue());
            return entity;
        }
        return this.cachedNextNodeEntity;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public final Entity getPreviousNodeClient() {
        block6: {
            Entity entity;
            block5: {
                if (this.cachedPrevNodeEntity == null) break block5;
                Entity entity2 = this.cachedPrevNodeEntity;
                if (entity2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!entity2.func_70089_S()) break block5;
                Entity entity3 = this.cachedPrevNodeEntity;
                if (entity3 == null) {
                    Intrinsics.throwNpe();
                }
                Integer n = (Integer)this.func_184212_Q().func_187225_a(DW_PREV_NODE);
                if (n != null && entity3.func_145782_y() == n.intValue()) break block6;
            }
            Object object = this.func_184212_Q().func_187225_a(DW_PREV_NODE);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getDataManager().get(DW_PREV_NODE)");
            this.cachedPrevNodeEntity = entity = this.field_70170_p.func_73045_a(((Number)object).intValue());
            return entity;
        }
        return this.cachedPrevNodeEntity;
    }

    private final Entity getNextNodeServer() {
        Entity nextNode = this.getNextNodeByUUID();
        if (nextNode != null && nextNode.func_145782_y() != this.cachedNextNodeDW) {
            this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)nextNode.func_145782_y());
            this.cachedNextNodeDW = nextNode.func_145782_y();
        } else if (nextNode == null && this.cachedNextNodeDW != -1) {
            this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)-1);
            this.cachedNextNodeDW = -1;
        }
        return nextNode;
    }

    private final Entity getPreviousNodeServer() {
        Entity prevNode = this.getPreviousNodeByUUID();
        if (prevNode != null && prevNode.func_145782_y() != this.cachedPrevNodeDW) {
            this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)prevNode.func_145782_y());
            this.cachedPrevNodeDW = prevNode.func_145782_y();
        } else if (prevNode == null && this.cachedPrevNodeDW != -1) {
            this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)-1);
            this.cachedPrevNodeDW = -1;
        }
        return prevNode;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DW_PREV_NODE, (Object)-1);
        this.cachedPrevNodeDW = -1;
        this.func_184212_Q().func_187214_a(DW_NEXT_NODE, (Object)-1);
        this.cachedNextNodeDW = -1;
    }

    protected void func_70037_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        this.setNextNodeUUID(nbt.func_186855_b(TAG_NEXT_NODE_UUID) ? nbt.func_186857_a(TAG_NEXT_NODE_UUID) : null);
        this.setPreviousNodeUUID(nbt.func_186855_b(TAG_PREVIOUS_NODE_UUID) ? nbt.func_186857_a(TAG_PREVIOUS_NODE_UUID) : null);
        this.pickUp = nbt.func_74767_n(TAG_PICK_UP);
        this.canExtend = nbt.func_74767_n(TAG_CAN_EXTEND);
        this.despawnTimer = nbt.func_74762_e(TAG_DESPAWN_TIMER);
        this.lightBlock = (BlockPos)NbtTagExtensionsKt.fallbackNull$default(nbt, TAG_LIGHT_BLOCK, readEntityFromNBT.1.INSTANCE, null, 4, null);
    }

    protected void func_70014_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        if (this.nextNodeUUID != null) {
            UUID uUID = this.nextNodeUUID;
            if (uUID == null) {
                Intrinsics.throwNpe();
            }
            nbt.func_186854_a(TAG_NEXT_NODE_UUID, uUID);
        }
        if (this.previousNodeUUID != null) {
            UUID uUID = this.previousNodeUUID;
            if (uUID == null) {
                Intrinsics.throwNpe();
            }
            nbt.func_186854_a(TAG_PREVIOUS_NODE_UUID, uUID);
        }
        nbt.func_74757_a(TAG_PICK_UP, this.pickUp);
        nbt.func_74757_a(TAG_CAN_EXTEND, this.canExtend);
        nbt.func_74768_a(TAG_DESPAWN_TIMER, this.despawnTimer);
        NbtTagExtensionsKt.setNullable(nbt, TAG_LIGHT_BLOCK, writeEntityToNBT.1.INSTANCE, this.lightBlock);
    }

    public void func_70030_z() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        boolean mobile = this.isMobile();
        boolean attached = this.isAttached();
        if (mobile && !attached) {
            this.func_70072_I();
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        boolean prevAttached = attached;
        attached = this.isAttached();
        if (attached && !prevAttached) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187778_dq, SoundCategory.PLAYERS, 1.0f, 1.5f);
        }
        Entity nextNode = this.getNextNode();
        if (!this.field_70170_p.field_72995_K && nextNode instanceof EntityPlayer) {
            this.pickUpThisNode((EntityPlayer)nextNode);
            this.dropNewNode((EntityPlayer)nextNode);
        }
        if (!this.func_70089_S()) {
            return;
        }
        if (this.isEmittingLight()) {
            this.handleLightBlocks(attached);
        }
        Entity prevNode = this.getPrevNode();
        if (mobile) {
            this.handleRopeMovement(attached, nextNode, prevNode);
        }
        this.processDespawn(nextNode, prevNode);
    }

    private final void handleLightBlocks(boolean attached) {
        if (attached) {
            BlockPos pos2 = this.func_180425_c();
            if (this.lightBlock != null && Intrinsics.areEqual((Object)this.lightBlock, (Object)pos2) ^ true) {
                this.destroyLightSource();
            }
            if (this.lightBlock == null && this.field_70170_p.func_175623_d(pos2)) {
                this.field_70170_p.func_175656_a(pos2, this.getLightBlock().func_176223_P());
                this.lightBlock = pos2;
            }
        } else if (this.lightBlock != null) {
            this.destroyLightSource();
        }
    }

    private final void destroyLightSource() {
        BlockPos blockPos2 = this.lightBlock;
        if (blockPos2 == null) {
            return;
        }
        BlockPos block = blockPos2;
        if (this.field_70170_p.func_175667_e(block)) {
            IBlockState iBlockState = this.field_70170_p.func_180495_p(block);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(block)");
            if (iBlockState.func_177230_c() == this.getLightBlock()) {
                this.field_70170_p.func_175698_g(block);
            }
        }
        this.lightBlock = null;
    }

    private final void processDespawn(Entity nextNode, Entity prevNode) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (nextNode == null) {
            if (prevNode == null) {
                this.func_174812_G();
            } else {
                int n = this.despawnTimer;
                this.despawnTimer = n + 1;
                if (this.despawnTimer >= 24000) {
                    if (prevNode instanceof EntityRopeNodeBase) {
                        EntityRopeNodeBase prevRopeNode = (EntityRopeNodeBase)prevNode;
                        prevRopeNode.setNextNode(null);
                        prevRopeNode.despawn();
                    }
                    this.func_174812_G();
                }
            }
        } else {
            this.despawnTimer = 0;
        }
    }

    private final void handleRopeMovement(boolean attached, Entity nextNode, Entity prevNode) {
        Vec3d diff;
        Vec3d constrainedPoint;
        double mz;
        double my;
        double mx;
        Vec3d nextPoint;
        Vec3d tetherPoint;
        Vec3d connection;
        if (attached || this.field_70122_E || this.field_70171_ac) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        this.field_70181_x *= 0.88;
        this.field_70159_w *= 0.88;
        this.field_70179_y *= 0.88;
        boolean isFloating = false;
        if (nextNode != null && (double)this.func_70032_d(nextNode) >= ROPE_LENGTH && (connection = this.getConnectionToNext()) != null) {
            double mx2 = connection.field_72450_a * 0.02;
            double my2 = connection.field_72448_b * 0.02;
            double mz2 = connection.field_72449_c * 0.02;
            double len = Math.sqrt(mx2 * mx2 + my2 * my2 + mz2 * mz2);
            if (len > 0.5) {
                mx2 /= len * 0.5;
                my2 /= len * 0.5;
                mz2 /= len * 0.5;
            }
            if (prevNode != null && prevNode.func_70011_f(this.field_70165_t + mx2, this.field_70163_u + my2, this.field_70161_v + mz2) < ROPE_LENGTH + 1.0) {
                this.field_70159_w += mx2;
                this.field_70179_y += mz2;
                this.field_70181_x += my2;
                isFloating = true;
            }
        }
        if (!isFloating) {
            this.field_70181_x -= 0.28;
        }
        if (nextNode != null && (tetherPoint = new Vec3d(nextNode.field_70165_t, nextNode.field_70163_u, nextNode.field_70161_v)).func_72438_d(nextPoint = new Vec3d(this.field_70165_t + (mx = this.field_70159_w), this.field_70163_u + (my = this.field_70181_x), this.field_70161_v + (mz = this.field_70179_y))) >= ROPE_LENGTH) {
            constrainedPoint = nextPoint.func_178788_d(tetherPoint).func_72432_b();
            constrainedPoint = new Vec3d(constrainedPoint.field_72450_a * ROPE_LENGTH, constrainedPoint.field_72448_b * ROPE_LENGTH, constrainedPoint.field_72449_c * ROPE_LENGTH).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
            diff = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178788_d(constrainedPoint);
            this.field_70159_w = -diff.field_72450_a;
            this.field_70181_x = -diff.field_72448_b;
            this.field_70179_y = -diff.field_72449_c;
        }
        if (prevNode != null && (tetherPoint = new Vec3d(prevNode.field_70165_t, prevNode.field_70163_u, prevNode.field_70161_v)).func_72438_d(nextPoint = new Vec3d(this.field_70165_t + (mx = this.field_70159_w), this.field_70163_u + (my = this.field_70181_x), this.field_70161_v + (mz = this.field_70179_y))) >= ROPE_LENGTH) {
            constrainedPoint = nextPoint.func_178788_d(tetherPoint).func_72432_b();
            constrainedPoint = new Vec3d(constrainedPoint.field_72450_a * ROPE_LENGTH, constrainedPoint.field_72448_b * ROPE_LENGTH, constrainedPoint.field_72449_c * ROPE_LENGTH).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
            diff = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178788_d(constrainedPoint).func_186678_a(0.8);
            this.field_70159_w = -diff.field_72450_a;
            this.field_70181_x = -diff.field_72448_b;
            this.field_70179_y = -diff.field_72449_c;
        }
        double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        this.field_70159_w *= Math.min(speed, 0.05) / 0.05;
        this.field_70181_x *= Math.min(speed, 0.05) / 0.05;
        this.field_70179_y *= Math.min(speed, 0.05) / 0.05;
    }

    private final void pickUpThisNode(EntityPlayer player) {
        float nodeDistance = player.func_70032_d((Entity)this);
        if (!this.pickUp) {
            this.pickUp = nodeDistance > 1.5f;
        } else if (player.func_174813_aQ().func_72314_b(0.4, 0.4, 0.4).func_72326_a(this.func_174813_aQ())) {
            this.removeNode((Entity)player);
            this.registerPickUp(player);
        }
    }

    protected void registerPickUp(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
    }

    private final void dropNewNode(EntityPlayer player) {
        Vec3d connection;
        float nodeDistance = player.func_70032_d((Entity)this);
        if ((double)nodeDistance < ROPE_LENGTH - 1.0) {
            this.canExtend = true;
        }
        if (this.canExtend && (double)nodeDistance > ROPE_LENGTH + 1.0 && this.canDropNewNode(player) && (connection = this.getConnectionToNext()) != null) {
            Vec3d newPos;
            Vec3d playerPosition = player.func_174791_d();
            RayTraceResult result = this.field_70170_p.func_72901_a(playerPosition, newPos = playerPosition.func_178787_e(connection.func_186678_a(-0.5)).func_72441_c(0.0, 0.1, 0.0), false);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.field_72307_f.func_72436_e(playerPosition) < newPos.func_72436_e(playerPosition)) {
                newPos = result.field_72307_f.func_178787_e(result.field_72307_f.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.1));
            }
            this.extendRope(player, newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        }
        if ((double)nodeDistance > ROPE_LENGTH_MAX) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.rope.disconnected", new Object[0]), true);
            this.setNextNode(null);
        }
    }

    protected boolean canDropNewNode(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return true;
    }

    public boolean func_184230_a(@NotNull EntityPlayer player, @NotNull EnumHand hand2) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity prevNode = this.getPreviousNodeByUUID();
        Entity nextNode = this.getNextNodeByUUID();
        Class<? extends EntityRopeNodeBase> entityClass = this.getEntityClass();
        if (prevNode != null) {
            if (nextNode == null) {
                Object v1;
                block10: {
                    List list2 = player.field_70170_p.field_72996_f;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"player.world.loadedEntityList");
                    Sequence $receiver$iv = SequencesKt.filterIsInstance(IterableExtensionsKt.getS(list2), entityClass);
                    for (Object element$iv : $receiver$iv) {
                        EntityRopeNodeBase node = (EntityRopeNodeBase)((Object)element$iv);
                        if (!(node.getNextNodeByUUID() == player)) continue;
                        v1 = element$iv;
                        break block10;
                    }
                    v1 = null;
                }
                EntityRopeNodeBase connectedRopeNode = v1;
                if (connectedRopeNode != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.rope.already_connected", new Object[0]), true);
                    return false;
                }
                this.setNextNode((Entity)player);
                return true;
            }
            if (!entityClass.isInstance(nextNode)) {
                this.setNextNode(null);
                return true;
            }
        }
        if (entityClass.isInstance(nextNode)) {
            EntityRopeNodeBase endNode;
            EntityRopeNodeBase entityRopeNodeBase = (EntityRopeNodeBase)nextNode;
            if (entityRopeNodeBase == null) {
                Intrinsics.throwNpe();
            }
            if ((endNode = this.getLastConnectedNode(entityRopeNodeBase)).getNextNodeByUUID() == null && entityClass.isInstance(endNode.getPreviousNodeByUUID())) {
                Entity entity = endNode.getPreviousNodeByUUID();
                if (entity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type aurocosh.divinefavor.common.entity.rope.base.EntityRopeNodeBase");
                }
                ((EntityRopeNodeBase)entity).setNextNode(null);
                endNode.func_70106_y();
                this.registerPickUp(player);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final EntityRopeNodeBase getLastConnectedNode(@NotNull EntityRopeNodeBase endNode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)endNode), (String)"endNode");
        EntityRopeNodeBase node = endNode;
        Class<? extends EntityRopeNodeBase> clazz = this.getEntityClass();
        while (clazz.isInstance(node.getNextNodeByUUID()) && node.getNextNodeByUUID() != this) {
            Entity entity = node.getNextNodeByUUID();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type aurocosh.divinefavor.common.entity.rope.base.EntityRopeNodeBase");
            }
            node = (EntityRopeNodeBase)entity;
        }
        return node;
    }

    public boolean func_70067_L() {
        return true;
    }

    @NotNull
    protected Block getLightBlock() {
        return ModBlocks.INSTANCE.getStandardRopeLight();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.lightBlock != null) {
            this.destroyLightSource();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    public final void removeNode(@NotNull Entity nextConnectionNode) {
        Intrinsics.checkParameterIsNotNull((Object)nextConnectionNode, (String)"nextConnectionNode");
        Entity prevNode = this.getPreviousNodeByUUID();
        if (prevNode instanceof EntityRopeNodeBase) {
            EntityRopeNodeBase node = (EntityRopeNodeBase)prevNode;
            node.setNextNode(nextConnectionNode);
            node.canExtend = false;
        }
        this.func_174812_G();
    }

    public final void despawn() {
        this.despawnTimer = 24000;
    }

    @NotNull
    protected abstract EntityRopeNodeBase makeNewNode(@NotNull World var1);

    public final void extendRope(@NotNull EntityPlayer player, double x, double y, double z) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (!this.canDropNewNode(player)) {
            return;
        }
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EntityRopeNodeBase ropeNode = this.makeNewNode(world);
        ropeNode.func_70012_b(x, y, z, 0.0f, 0.0f);
        ropeNode.setPreviousNode(this);
        ropeNode.setNextNode((Entity)player);
        this.setNextNode(ropeNode);
        this.field_70170_p.func_72838_d((Entity)ropeNode);
        if (ropeNode.isAttached()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187778_dq, SoundCategory.PLAYERS, 1.0f, 1.5f);
        }
    }

    public final void setPreviousNode(@Nullable Entity entity) {
        this.cachedPrevNodeEntity = entity;
        Entity entity2 = entity;
        this.setPreviousNodeUUID(entity2 != null ? entity2.func_110124_au() : null);
    }

    private final Entity getEntityByUUID(UUID uuid) {
        AxisAlignedBB alignedBB = this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0);
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        AxisAlignedBB axisAlignedBB = alignedBB;
        Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB, (String)"alignedBB");
        return UtilEntity.INSTANCE.getEntityByUUID(world, Entity.class, axisAlignedBB, uuid);
    }

    public EntityRopeNodeBase(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.canExtend = true;
        this.func_70105_a(0.1f, 0.1f);
    }

    static {
        Companion = new Companion(null);
        DW_PREV_NODE = EntityDataManager.func_187226_a(EntityRopeNodeBase.class, (DataSerializer)DataSerializers.field_187192_b);
        DW_NEXT_NODE = EntityDataManager.func_187226_a(EntityRopeNodeBase.class, (DataSerializer)DataSerializers.field_187192_b);
        ROPE_LENGTH = 4.0;
        ROPE_LENGTH_SQ = ROPE_LENGTH * ROPE_LENGTH;
        ROPE_LENGTH_MAX = 12.0;
        TAG_NEXT_NODE_UUID = TAG_NEXT_NODE_UUID;
        TAG_PREVIOUS_NODE_UUID = TAG_PREVIOUS_NODE_UUID;
        TAG_PICK_UP = TAG_PICK_UP;
        TAG_CAN_EXTEND = TAG_CAN_EXTEND;
        TAG_DESPAWN_TIMER = TAG_DESPAWN_TIMER;
        TAG_LIGHT_BLOCK = TAG_LIGHT_BLOCK;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Laurocosh/divinefavor/common/entity/rope/base/EntityRopeNodeBase$Companion;", "", "()V", "DW_NEXT_NODE", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "DW_PREV_NODE", "ROPE_LENGTH", "", "getROPE_LENGTH", "()D", "ROPE_LENGTH_MAX", "getROPE_LENGTH_MAX", "ROPE_LENGTH_SQ", "getROPE_LENGTH_SQ", "TAG_CAN_EXTEND", "", "TAG_DESPAWN_TIMER", "TAG_LIGHT_BLOCK", "TAG_NEXT_NODE_UUID", "TAG_PICK_UP", "TAG_PREVIOUS_NODE_UUID", "divinefavor"})
    public static final class Companion {
        public final double getROPE_LENGTH() {
            return ROPE_LENGTH;
        }

        public final double getROPE_LENGTH_SQ() {
            return ROPE_LENGTH_SQ;
        }

        public final double getROPE_LENGTH_MAX() {
            return ROPE_LENGTH_MAX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

