/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.event_handlers;

import aurocosh.divinefavor.common.lib.extensions.LivingBaseExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Laurocosh/divinefavor/common/event_handlers/EntityEventHandler;", "", "()V", "onLivingDropsEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDropsEvent;", "onLivingExperienceDropEvent", "Lnet/minecraftforge/event/entity/living/LivingExperienceDropEvent;", "onLootingLevelEvent", "Lnet/minecraftforge/event/entity/living/LootingLevelEvent;", "divinefavor"})
public final class EntityEventHandler {
    public static final EntityEventHandler INSTANCE;

    @SubscribeEvent
    public final void onLootingLevelEvent(@NotNull LootingLevelEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int n = event.getLootingLevel();
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"event.entityLiving");
        event.setLootingLevel(n + LivingBaseExtensionsKt.getDivineLivingData(entityLivingBase).getExtraLootingData().getExtraLooting());
    }

    @SubscribeEvent
    public final void onLivingDropsEvent(@NotNull LivingDropsEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"event.entityLiving");
        if (LivingBaseExtensionsKt.getDivineLivingData(entityLivingBase).getExtraLootingData().isLootDenied()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onLivingExperienceDropEvent(@NotNull LivingExperienceDropEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"event.entityLiving");
        if (LivingBaseExtensionsKt.getDivineLivingData(entityLivingBase).getExtraLootingData().isExperienceDenied()) {
            event.setCanceled(true);
        }
    }

    private EntityEventHandler() {
    }

    static {
        EntityEventHandler entityEventHandler;
        INSTANCE = entityEventHandler = new EntityEventHandler();
    }
}

