/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.global.dayClock;

import aurocosh.divinefavor.common.config.common.ConfigGeneral;
import aurocosh.divinefavor.common.global.dayClock.ClockAlarmCallback;
import aurocosh.divinefavor.common.global.dayClock.DayTimeAlarm;
import aurocosh.divinefavor.common.global.dayClock.DayTimeAlarmComparator;
import aurocosh.divinefavor.common.global.dayClock.DayTimeAlarmId;
import aurocosh.divinefavor.common.global.dayClock.DayTimeAlarmNormal;
import aurocosh.divinefavor.common.lib.LoopedCounter;
import aurocosh.divinefavor.common.lib.extensions.ListExtensionsKt;
import aurocosh.divinefavor.common.util.UtilDayTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0007H\u0002J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006'"}, d2={"Laurocosh/divinefavor/common/global/dayClock/DayClock;", "", "()V", "DAY_TIME_COUNTER", "Laurocosh/divinefavor/common/lib/LoopedCounter;", "SYNC_COUNTER", "TRACKED_DIMENSION_ID", "", "alarms", "Ljava/util/LinkedList;", "Laurocosh/divinefavor/common/global/dayClock/DayTimeAlarm;", "nextId", "timeHours", "getTimeHours", "()I", "timeTicks", "getTimeTicks", "addAlarm", "dayTimeInTicks", "callback", "Lkotlin/Function0;", "", "repeat", "", "Laurocosh/divinefavor/common/global/dayClock/ClockAlarmCallback;", "enqueueAlarm", "alarm", "onCommand", "event", "Lnet/minecraftforge/event/CommandEvent;", "onSleep", "Lnet/minecraftforge/event/entity/player/PlayerSleepInBedEvent;", "processAlarms", "time", "removeAlarm", "id", "serverTickEnd", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ServerTickEvent;", "syncTime", "divinefavor"})
public final class DayClock {
    private static final int TRACKED_DIMENSION_ID = 0;
    private static final LoopedCounter SYNC_COUNTER;
    private static final LoopedCounter DAY_TIME_COUNTER;
    private static final LinkedList<DayTimeAlarm> alarms;
    private static int nextId;
    public static final DayClock INSTANCE;

    public final int getTimeTicks() {
        return DAY_TIME_COUNTER.getCount();
    }

    public final int getTimeHours() {
        return DAY_TIME_COUNTER.getCount() / UtilDayTime.INSTANCE.getTICKS_IN_DAY();
    }

    public final int addAlarm(int dayTimeInTicks, @NotNull Function0<Unit> callback, boolean repeat) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        int n = nextId;
        nextId = n + 1;
        DayTimeAlarmNormal alarm = new DayTimeAlarmNormal(n, dayTimeInTicks, repeat, callback);
        this.enqueueAlarm(alarm);
        return alarm.getId();
    }

    public final int addAlarm(int dayTimeInTicks, @NotNull ClockAlarmCallback callback, boolean repeat) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        int n = nextId;
        nextId = n + 1;
        DayTimeAlarmId alarm = new DayTimeAlarmId(n, dayTimeInTicks, repeat, callback);
        this.enqueueAlarm(alarm);
        return alarm.getId();
    }

    public final void removeAlarm(int id) {
        int index2 = ListExtensionsKt.firstIndex((List)alarms, (Function1)new Function1<DayTimeAlarm, Boolean>(id){
            final /* synthetic */ int $id;

            public final boolean invoke(@NotNull DayTimeAlarm alarm) {
                Intrinsics.checkParameterIsNotNull((Object)alarm, (String)"alarm");
                return alarm.getId() == this.$id;
            }
            {
                this.$id = n;
                super(1);
            }
        });
        if (index2 != -1) {
            alarms.remove(index2);
        }
    }

    @SubscribeEvent
    public final void serverTickEnd(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        DAY_TIME_COUNTER.tick();
        if (SYNC_COUNTER.tick()) {
            this.syncTime();
        }
        int time = DAY_TIME_COUNTER.getCount();
        this.processAlarms(time);
    }

    private final void syncTime() {
        WorldServer worldServer = DimensionManager.getWorld((int)TRACKED_DIMENSION_ID);
        if (worldServer == null) {
            return;
        }
        WorldServer world = worldServer;
        int time = UtilDayTime.INSTANCE.getDayTime((World)world);
        DAY_TIME_COUNTER.setCount(time);
        CollectionsKt.sortWith((List)alarms, (Comparator)new DayTimeAlarmComparator());
        ArrayList<DayTimeAlarm> alarmsToMove = new ArrayList<DayTimeAlarm>();
        while (alarms.peek() != null && alarms.peek().getTime() < time) {
            alarmsToMove.add(alarms.remove());
        }
        alarms.addAll((Collection<DayTimeAlarm>)alarmsToMove);
    }

    private final void processAlarms(int time) {
        ArrayList<DayTimeAlarm> alarmsToRepeat = new ArrayList<DayTimeAlarm>();
        while (alarms.peek() != null && alarms.peek().getTime() == time) {
            DayTimeAlarm alarm = alarms.remove();
            alarm.activate();
            if (!alarm.getRepeat()) continue;
            alarmsToRepeat.add(alarm);
        }
        alarms.addAll((Collection<DayTimeAlarm>)alarmsToRepeat);
    }

    private final void enqueueAlarm(DayTimeAlarm alarm) {
        int index2 = ListExtensionsKt.firstIndex((List)alarms, (Function1)new Function1<DayTimeAlarm, Boolean>(alarm){
            final /* synthetic */ DayTimeAlarm $alarm;

            public final boolean invoke(@NotNull DayTimeAlarm existingAlarm) {
                Intrinsics.checkParameterIsNotNull((Object)existingAlarm, (String)"existingAlarm");
                return existingAlarm.getTime() >= this.$alarm.getTime();
            }
            {
                this.$alarm = dayTimeAlarm;
                super(1);
            }
        });
        if (index2 != -1) {
            alarms.add(index2, alarm);
        } else {
            alarms.add(alarm);
        }
    }

    @SubscribeEvent
    public final void onCommand(@NotNull CommandEvent event) {
        ICommand command;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        ICommand iCommand = command = event.getCommand();
        Intrinsics.checkExpressionValueIsNotNull((Object)iCommand, (String)"command");
        String name = iCommand.func_71517_b();
        if (Intrinsics.areEqual((Object)name, (Object)"time")) {
            this.syncTime();
        }
    }

    @SubscribeEvent
    public final void onSleep(@NotNull PlayerSleepInBedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.syncTime();
    }

    private DayClock() {
    }

    static {
        DayClock dayClock;
        INSTANCE = dayClock = new DayClock();
        SYNC_COUNTER = new LoopedCounter(ConfigGeneral.timeSyncPeriod);
        DAY_TIME_COUNTER = new LoopedCounter(UtilDayTime.INSTANCE.getTICKS_IN_DAY());
        alarms = new LinkedList();
    }
}

