/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.integrations.patchouli.processors;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.item.arrow_talismans.base.ArrowOptions;
import aurocosh.divinefavor.common.item.arrow_talismans.base.ItemArrowTalisman;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Laurocosh/divinefavor/common/integrations/patchouli/processors/ArrowTalismanStatProcessor;", "Lvazkii/patchouli/api/IComponentProcessor;", "()V", "arrowTalisman", "Laurocosh/divinefavor/common/item/arrow_talismans/base/ItemArrowTalisman;", "getArrowTalisman", "()Laurocosh/divinefavor/common/item/arrow_talismans/base/ItemArrowTalisman;", "setArrowTalisman", "(Laurocosh/divinefavor/common/item/arrow_talismans/base/ItemArrowTalisman;)V", "itemStack", "Lnet/minecraft/item/ItemStack;", "getItemStack", "()Lnet/minecraft/item/ItemStack;", "setItemStack", "(Lnet/minecraft/item/ItemStack;)V", "process", "", "key", "setup", "", "variables", "Lvazkii/patchouli/api/IVariableProvider;", "divinefavor"})
public final class ArrowTalismanStatProcessor
implements IComponentProcessor {
    @NotNull
    public ItemArrowTalisman arrowTalisman;
    @NotNull
    public ItemStack itemStack;

    @NotNull
    public final ItemArrowTalisman getArrowTalisman() {
        ItemArrowTalisman itemArrowTalisman = this.arrowTalisman;
        if (itemArrowTalisman == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
        }
        return itemArrowTalisman;
    }

    public final void setArrowTalisman(@NotNull ItemArrowTalisman itemArrowTalisman) {
        Intrinsics.checkParameterIsNotNull((Object)itemArrowTalisman, (String)"<set-?>");
        this.arrowTalisman = itemArrowTalisman;
    }

    @NotNull
    public final ItemStack getItemStack() {
        ItemStack itemStack = this.itemStack;
        if (itemStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemStack");
        }
        return itemStack;
    }

    public final void setItemStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"<set-?>");
        this.itemStack = itemStack;
    }

    public void setup(@NotNull IVariableProvider<String> variables) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        String talismanName = (String)variables.get("talisman");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(talismanName));
        if (item instanceof ItemArrowTalisman) {
            this.arrowTalisman = (ItemArrowTalisman)item;
            this.itemStack = new ItemStack(item);
        } else {
            DivineFavor.INSTANCE.getLogger().error("Arrow talisman not found:" + talismanName);
        }
    }

    @Nullable
    public String process(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ItemStack itemStack = this.itemStack;
        if (itemStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemStack");
        }
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (StringsKt.startsWith$default((String)key, (String)"talisman", (boolean)false, (int)2, null)) {
            ItemStack itemStack2 = this.itemStack;
            if (itemStack2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"itemStack");
            }
            return ItemStackUtil.serializeStack((ItemStack)itemStack2);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"spirit_icon")) {
            ItemArrowTalisman itemArrowTalisman = this.arrowTalisman;
            if (itemArrowTalisman == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            ModSpirit spirit = itemArrowTalisman.getSpirit();
            return spirit.getIcon().toString();
        }
        if (Intrinsics.areEqual((Object)key, (Object)"spirit_symbol")) {
            ItemArrowTalisman itemArrowTalisman = this.arrowTalisman;
            if (itemArrowTalisman == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            ModSpirit spirit = itemArrowTalisman.getSpirit();
            return spirit.getSymbol().toString();
        }
        if (Intrinsics.areEqual((Object)key, (Object)"text")) {
            EnumSet<ArrowOptions> options;
            double arrowDamage;
            int favorCost;
            ArrayList<String> lines = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder().append("Favor: ");
            ItemArrowTalisman itemArrowTalisman = this.arrowTalisman;
            if (itemArrowTalisman == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            lines.add(stringBuilder.append(itemArrowTalisman.getSpirit().getName()).toString());
            ItemArrowTalisman itemArrowTalisman2 = this.arrowTalisman;
            if (itemArrowTalisman2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            ItemStack itemStack3 = this.itemStack;
            if (itemStack3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"itemStack");
            }
            if ((favorCost = itemArrowTalisman2.getApproximateFavorCost(itemStack3)) == 0) {
                lines.add("No cost");
            } else {
                lines.add("Favor cost: " + favorCost);
            }
            ItemArrowTalisman itemArrowTalisman3 = this.arrowTalisman;
            if (itemArrowTalisman3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            if ((arrowDamage = itemArrowTalisman3.getArrowDamage()) == 0.0) {
                lines.add("Arrow deals no damage");
            } else {
                DecimalFormat formatter = new DecimalFormat("#0.00");
                lines.add("Arrow damage: " + formatter.format(arrowDamage));
            }
            ItemArrowTalisman itemArrowTalisman4 = this.arrowTalisman;
            if (itemArrowTalisman4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrowTalisman");
            }
            if (Intrinsics.areEqual(options = itemArrowTalisman4.getOptions(), ArrowOptions.Companion.getNORMAL())) {
                lines.add("No extra properties");
            } else {
                lines.add("Extra properties: ");
                if (options.contains((Object)ArrowOptions.BreakOnHit)) {
                    lines.add("  Will break on hit. ");
                }
                if (options.contains((Object)ArrowOptions.RequiresTarget)) {
                    lines.add("  Needs target.");
                }
            }
            return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"$(br)", null, null, (int)0, null, null, (int)62, null);
        }
        return null;
    }
}

