/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.integrations.patchouli.processors;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.lib.TimePeriod;
import aurocosh.divinefavor.common.registry.ModRegistries;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.util.UtilDayTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Laurocosh/divinefavor/common/integrations/patchouli/processors/SpiritInfoProcessor;", "Lvazkii/patchouli/api/IComponentProcessor;", "()V", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "text", "", "process", "key", "setup", "", "variables", "Lvazkii/patchouli/api/IVariableProvider;", "divinefavor"})
public final class SpiritInfoProcessor
implements IComponentProcessor {
    private String text = "";
    private ModSpirit spirit;

    public void setup(@NotNull IVariableProvider<String> variables) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        String name = (String)variables.get("spirit");
        ResourceLocation spiritId = new ResourceLocation(name);
        this.spirit = ModRegistries.INSTANCE.getSpirits().getValue(spiritId);
        if (this.spirit == null) {
            DivineFavor.INSTANCE.getLogger().error("Spirit not found:" + name);
        }
        Object object = variables.get("text");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"variables.get(\"text\")");
        this.text = (String)object;
    }

    @Nullable
    public String process(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ModSpirit spirit = this.spirit;
        if (Intrinsics.areEqual((Object)key, (Object)"text")) {
            String result = this.text;
            if (spirit != null) {
                TimePeriod activityPeriod = spirit.getActivityPeriod();
                int start = activityPeriod.getStart() / UtilDayTime.INSTANCE.getTICKS_IN_HOUR();
                int stop = activityPeriod.getStop() / UtilDayTime.INSTANCE.getTICKS_IN_HOUR();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "$(br)This spirit is active from %d o'clock to %d o'clock.";
                Object[] objectArray = new Object[]{start, stop};
                StringBuilder stringBuilder = new StringBuilder().append(result);
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                result = stringBuilder.append(string3).toString();
            }
            return result;
        }
        return null;
    }
}

