/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.integrations.patchouli.processors;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.registry.mappers.ModMappers;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Laurocosh/divinefavor/common/integrations/patchouli/processors/SpiritOfferingProcessor;", "Lvazkii/patchouli/api/IComponentProcessor;", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "offering", "Lnet/minecraft/item/Item;", "getOffering", "()Lnet/minecraft/item/Item;", "setOffering", "(Lnet/minecraft/item/Item;)V", "process", "", "key", "setup", "", "variables", "Lvazkii/patchouli/api/IVariableProvider;", "divinefavor"})
public final class SpiritOfferingProcessor
implements IComponentProcessor {
    private int count;
    @Nullable
    private Item offering;

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    @Nullable
    public final Item getOffering() {
        return this.offering;
    }

    public final void setOffering(@Nullable Item item) {
        this.offering = item;
    }

    public void setup(@NotNull IVariableProvider<String> variables) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        String spiritName = (String)variables.get("spirit");
        ModSpirit spirit = ModMappers.INSTANCE.getSpirits().get(new ResourceLocation(spiritName));
        if (spirit == null) {
            DivineFavor.INSTANCE.getLogger().error("Spirit not found:" + spiritName);
            return;
        }
        this.offering = spirit.getOffering();
        this.count = spirit.getOfferingCount();
    }

    @Nullable
    public String process(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Item item = this.offering;
        if (item == null) {
            return null;
        }
        Item offering = item;
        if (StringsKt.startsWith$default((String)key, (String)"offering", (boolean)false, (int)2, null)) {
            ItemStack stack2 = new ItemStack(offering, this.count);
            return ItemStackUtil.serializeStack((ItemStack)stack2);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"text")) {
            return I18n.func_135052_a((String)"divinefavor:spirit_offering", (Object[])new Object[]{this.count});
        }
        return null;
    }
}

