/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.block.common.ModBlocks;
import aurocosh.divinefavor.common.constants.ConstMainTabOrder;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.lib.extensions.ItemStackExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyBool;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyInt;
import aurocosh.divinefavor.common.util.UtilBlock;
import aurocosh.divinefavor.common.util.UtilItemStack;
import aurocosh.divinefavor.common.util.UtilStatus;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016JH\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0016J0\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Laurocosh/divinefavor/common/item/ItemGooVial;", "Laurocosh/divinefavor/common/item/base/ModItem;", "name", "", "capacity", "", "(Ljava/lang/String;I)V", "getCapacity", "()I", "quarterCapacity", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "collect", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "pos", "Lnet/minecraft/util/math/BlockPos;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "worldIn", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "place", "switchMode", "Companion", "divinefavor"})
public final class ItemGooVial
extends ModItem {
    private final int quarterCapacity;
    private final int capacity;
    @NotNull
    private static final StackPropertyInt gooCount;
    @NotNull
    private static final StackPropertyBool isCollecting;
    public static final Companion Companion;

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumHand hand2, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack stack2 = player.func_184586_b(hand2);
        if (player.func_70093_af()) {
            ItemStack itemStack = stack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            this.switchMode(player, itemStack);
            return EnumActionResult.SUCCESS;
        }
        ItemStack itemStack = stack2;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        boolean collecting = (Boolean)ItemStackExtensionsKt.get(itemStack, isCollecting);
        boolean success = collecting ? this.collect(player, world, pos2, stack2) : this.place(player, world, pos2, stack2, facing);
        return UtilItemStack.INSTANCE.actionResultPass(success);
    }

    private final boolean place(EntityPlayer player, World world, BlockPos pos2, ItemStack stack2, EnumFacing facing) {
        IBlockState state2;
        BlockPos finalPos2;
        boolean replaceable = UtilBlock.INSTANCE.isAirOrReplaceable(world, pos2);
        BlockPos blockPos2 = finalPos2 = replaceable ? pos2 : pos2.func_177972_a(facing);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"finalPos");
        if (!UtilBlock.INSTANCE.isAirOrReplaceable(world, blockPos2)) {
            return false;
        }
        int count = ((Number)ItemStackExtensionsKt.get(stack2, gooCount)).intValue();
        if (count <= 0) {
            return false;
        }
        IBlockState iBlockState = state2 = ModBlocks.INSTANCE.getEthereal_goo().func_176223_P();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        boolean success = UtilBlock.INSTANCE.replaceBlock(player, world, finalPos2, iBlockState);
        if (success) {
            ItemStackExtensionsKt.set$default(stack2, gooCount, count - 1, false, 4, null);
        }
        return success;
    }

    private final boolean collect(EntityPlayer player, World world, BlockPos pos2, ItemStack stack2) {
        IBlockState state2;
        IBlockState blockState;
        IBlockState iBlockState = blockState = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
        if (iBlockState.func_177230_c() != ModBlocks.INSTANCE.getEthereal_goo()) {
            return false;
        }
        int count = ((Number)ItemStackExtensionsKt.get(stack2, gooCount)).intValue();
        if (count >= this.capacity) {
            return false;
        }
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
        IBlockState iBlockState2 = state2 = block.func_176223_P();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
        boolean success = UtilBlock.INSTANCE.replaceBlock(player, world, pos2, iBlockState2);
        if (success) {
            ItemStackExtensionsKt.set$default(stack2, gooCount, count + 1, false, 4, null);
        }
        return success;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer player, @NotNull EnumHand hand2) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        ItemStack stack2 = player.func_184586_b(hand2);
        if (player.func_70093_af()) {
            ItemStack itemStack = stack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            this.switchMode(player, itemStack);
            return UtilItemStack.INSTANCE.actionResult(true, stack2);
        }
        ItemStack itemStack = stack2;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        return UtilItemStack.INSTANCE.actionResult(false, itemStack);
    }

    private final void switchMode(EntityPlayer player, ItemStack stack2) {
        boolean collecting = (Boolean)ItemStackExtensionsKt.get(stack2, isCollecting) == false;
        ItemStackExtensionsKt.set$default(stack2, isCollecting, collecting, false, 4, null);
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (collecting) {
            PlayerExtensionsKt.sendStatusMessage$default(player, "message.divinefavor.goo_vial.collecting_goo", UtilStatus.INSTANCE.formatString(TextFormatting.AQUA), true, null, 8, null);
        } else {
            PlayerExtensionsKt.sendStatusMessage$default(player, "message.divinefavor.goo_vial.placing_goo", UtilStatus.INSTANCE.formatString(TextFormatting.AQUA), true, null, 8, null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack2, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        super.func_77624_a(stack2, world, tooltip, flag);
        int gooCount = ((Number)ItemStackExtensionsKt.get(stack2, ItemGooVial.gooCount)).intValue();
        String string = I18n.func_135052_a((String)"tooltip.divinefavor:goo_vial.count", (Object[])new Object[]{gooCount});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"tooltip.div\u2026oo_vial.count\", gooCount)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"tooltip.divinefavor:goo_vial.capacity", (Object[])new Object[]{this.capacity});
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"I18n.format(\"tooltip.div\u2026vial.capacity\", capacity)");
        tooltip.add(string2);
        boolean collecting = (Boolean)ItemStackExtensionsKt.get(stack2, isCollecting);
        if (collecting) {
            String string3 = I18n.func_135052_a((String)"tooltip.divinefavor:goo_vial.collecting", (Object[])new Object[]{this.capacity});
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"I18n.format(\"tooltip.div\u2026al.collecting\", capacity)");
            tooltip.add(string3);
        } else {
            String string4 = I18n.func_135052_a((String)"tooltip.divinefavor:goo_vial.placing", (Object[])new Object[]{this.capacity});
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"I18n.format(\"tooltip.div\u2026_vial.placing\", capacity)");
            tooltip.add(string4);
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ItemGooVial(@NotNull String name, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super("goo_vial_" + name, "goo_vials/" + name, ConstMainTabOrder.INSTANCE.getTOOLS());
        this.capacity = capacity;
        this.quarterCapacity = this.capacity / 4;
        this.func_77637_a(DivineFavor.INSTANCE.getTAB_MAIN());
        this.func_185043_a(new ResourceLocation("fullness"), new IItemPropertyGetter(){

            public final float func_185085_a(ItemStack stack2, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                ItemStack itemStack = stack2;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                return ((Number)ItemStackExtensionsKt.get(itemStack, Companion.getGooCount())).intValue() / quarterCapacity;
            }
        });
    }

    static {
        Companion = new Companion(null);
        gooCount = new StackPropertyInt("goo_count", 0, 0, Integer.MAX_VALUE, false, false, 0);
        isCollecting = new StackPropertyBool("collecting", true, false, false, 0, null, null, 96, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\n"}, d2={"Laurocosh/divinefavor/common/item/ItemGooVial$Companion;", "", "()V", "gooCount", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "getGooCount", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "isCollecting", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBool;", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBool;", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final StackPropertyInt getGooCount() {
            return gooCount;
        }

        @NotNull
        public final StackPropertyBool isCollecting() {
            return isCollecting;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

