/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item.arrow_talismans;

import aurocosh.divinefavor.common.config.common.ConfigArrow;
import aurocosh.divinefavor.common.entity.projectile.EntitySpellArrow;
import aurocosh.divinefavor.common.item.arrow_talismans.base.ArrowOptions;
import aurocosh.divinefavor.common.item.arrow_talismans.base.ArrowType;
import aurocosh.divinefavor.common.item.arrow_talismans.base.ItemArrowTalisman;
import aurocosh.divinefavor.common.lib.extensions.EntityExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.Vec3dExtensionsKt;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.util.UtilEntity;
import aurocosh.divinefavor.common.util.UtilRandom;
import java.awt.Color;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J6\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a8\u0006 "}, d2={"Laurocosh/divinefavor/common/item/arrow_talismans/ArrowTalismanRicochetArrow;", "Laurocosh/divinefavor/common/item/arrow_talismans/base/ItemArrowTalisman;", "name", "", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "favorCost", "", "color", "Ljava/awt/Color;", "arrowDamage", "", "options", "Ljava/util/EnumSet;", "Laurocosh/divinefavor/common/item/arrow_talismans/base/ArrowOptions;", "arrowType", "Laurocosh/divinefavor/common/item/arrow_talismans/base/ArrowType;", "(Ljava/lang/String;Laurocosh/divinefavor/common/spirit/base/ModSpirit;ILjava/awt/Color;DLjava/util/EnumSet;Laurocosh/divinefavor/common/item/arrow_talismans/base/ArrowType;)V", "performActionServer", "", "target", "Lnet/minecraft/entity/EntityLivingBase;", "shooter", "spellArrow", "Laurocosh/divinefavor/common/entity/projectile/EntitySpellArrow;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "sideHit", "Lnet/minecraft/util/EnumFacing;", "preInit", "", "Companion", "divinefavor"})
public final class ArrowTalismanRicochetArrow
extends ItemArrowTalisman {
    private static final String TAG_BOUNCES_LEFT = "BouncesLeft";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void preInit(@NotNull EntitySpellArrow spellArrow, @NotNull EntityLivingBase shooter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spellArrow), (String)"spellArrow");
        Intrinsics.checkParameterIsNotNull((Object)shooter, (String)"shooter");
        NBTTagCompound compound = spellArrow.getTalismanDataServer();
        compound.func_74768_a(TAG_BOUNCES_LEFT, ConfigArrow.ricochetArrow.maxBounces);
    }

    @Override
    protected boolean performActionServer(@Nullable EntityLivingBase target, @NotNull EntityLivingBase shooter, @NotNull EntitySpellArrow spellArrow, @Nullable BlockPos blockPos2, @Nullable EnumFacing sideHit) {
        Intrinsics.checkParameterIsNotNull((Object)shooter, (String)"shooter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)spellArrow), (String)"spellArrow");
        if (target != null) {
            return true;
        }
        if (sideHit == null) {
            return true;
        }
        NBTTagCompound compound = spellArrow.getTalismanDataServer();
        int bouncesLeft = compound.func_74762_e(TAG_BOUNCES_LEFT);
        if (bouncesLeft == 0) {
            return true;
        }
        compound.func_74768_a(TAG_BOUNCES_LEFT, bouncesLeft - 1);
        Vec3d motionVector = EntityExtensionsKt.getMotionVector((Entity)spellArrow);
        float speed = (float)motionVector.func_72433_c();
        if (speed < ConfigArrow.ricochetArrow.minBounceSpeed) {
            return true;
        }
        Vec3i sideVectorI = sideHit.func_176730_m();
        Vec3d randomChange = UtilRandom.INSTANCE.nextDirection().func_186678_a(ConfigArrow.ricochetArrow.bounceRandomness);
        Vec3d vec3d = motionVector.func_72432_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d, (String)"motionVector.normalize()");
        Vec3i vec3i = sideVectorI;
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3i, (String)"sideVectorI");
        Vec3d direction = Vec3dExtensionsKt.add(vec3d, vec3i).func_178787_e(randomChange);
        Entity entity = (Entity)spellArrow;
        Vec3d vec3d2 = direction;
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"direction");
        UtilEntity.INSTANCE.setVelocity(entity, vec3d2, speed * ConfigArrow.ricochetArrow.bounceSpeedDecrease);
        return false;
    }

    public ArrowTalismanRicochetArrow(@NotNull String name, @NotNull ModSpirit spirit, int favorCost, @NotNull Color color, double arrowDamage, @NotNull EnumSet<ArrowOptions> options, @NotNull ArrowType arrowType) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)((Object)arrowType), (String)"arrowType");
        super(name, spirit, favorCost, color, arrowDamage, options, arrowType);
    }

    static {
        TAG_BOUNCES_LEFT = TAG_BOUNCES_LEFT;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Laurocosh/divinefavor/common/item/arrow_talismans/ArrowTalismanRicochetArrow$Companion;", "", "()V", "TAG_BOUNCES_LEFT", "", "divinefavor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

