/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item.gems;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.constants.ConstGemTabOrder;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.item.gems.ItemWarpMarker;
import aurocosh.divinefavor.common.item.gems.base.IStackUsableGemItem;
import aurocosh.divinefavor.common.item.gems.properties.GemMaskProperties;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContext;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContextGenerator;
import aurocosh.divinefavor.common.item.talisman.ISelectedStackProvider;
import aurocosh.divinefavor.common.lib.EmptyConst;
import aurocosh.divinefavor.common.lib.extensions.ItemStackExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.stack_properties.StackPropertyHandler;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyAccessor;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyInt;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyString;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyUUID;
import aurocosh.divinefavor.common.stack_properties.properties.base.StackProperty;
import aurocosh.divinefavor.common.util.UtilEntity;
import aurocosh.divinefavor.common.util.UtilItemStack;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u0003:\u00018B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0016JH\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00069"}, d2={"Laurocosh/divinefavor/common/item/gems/ItemInviteMarker;", "Laurocosh/divinefavor/common/item/base/ModItem;", "Laurocosh/divinefavor/common/item/gems/base/IStackUsableGemItem;", "Laurocosh/divinefavor/common/item/talisman/ISelectedStackProvider;", "name", "", "canTeleportToDimensions", "", "consumeOnUse", "favorCost", "", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "maxStackSize", "(Ljava/lang/String;ZZILaurocosh/divinefavor/common/spirit/base/ModSpirit;I)V", "getConsumeOnUse", "()Z", "getFavorCost", "()I", "properties", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getProperties", "()Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getSpirit", "()Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "cast", "context", "Laurocosh/divinefavor/common/item/spell_talismans/context/CastContext;", "consumeFavor", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getSelectedStack", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "pos", "Lnet/minecraft/util/math/BlockPos;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "Companion", "divinefavor"})
public final class ItemInviteMarker
extends ModItem
implements IStackUsableGemItem,
ISelectedStackProvider {
    @NotNull
    private final IStackPropertyAccessor properties;
    private final boolean canTeleportToDimensions;
    private final boolean consumeOnUse;
    private final int favorCost;
    @NotNull
    private final ModSpirit spirit;
    @NotNull
    private static final StackPropertyHandler propertyHandler;
    @NotNull
    private static final StackPropertyString maskItemId;
    @NotNull
    private static final StackPropertyInt maskItemMeta;
    @NotNull
    private static final StackPropertyUUID playerId;
    @NotNull
    private static final StackPropertyString playerName;
    public static final Companion Companion;

    @Override
    @NotNull
    public IStackPropertyAccessor getProperties() {
        return this.properties;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand2) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.rightClick(world, player, hand2, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResult(result, stack2);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumHand hand2, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.useCast(player, world, pos2, hand2, facing, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResultPass(result);
    }

    @Override
    public boolean cast(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ItemStack stack2 = context.getStack();
        if (stack2.func_190926_b()) {
            return false;
        }
        if (!(stack2.func_77973_b() instanceof ItemInviteMarker)) {
            return false;
        }
        if (!ItemStackExtensionsKt.isPropertySet(stack2, ItemWarpMarker.Companion.getPosition())) {
            return false;
        }
        World world = context.getWorld();
        UUID uuid = (UUID)ItemStackExtensionsKt.get(stack2, playerId);
        MinecraftServer minecraftServer = world.func_73046_m();
        if (minecraftServer == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"world.minecraftServer ?: return false");
        MinecraftServer server = minecraftServer;
        PlayerList playerList = server.func_184103_al();
        EntityPlayerMP targetPlayer = playerList.func_177451_a(uuid);
        EntityPlayer player = context.getPlayer();
        int dimension = ((Number)ItemStackExtensionsKt.get(stack2, ItemWarpMarker.Companion.getDimension())).intValue();
        if (!this.canTeleportToDimensions && dimension != player.field_71093_bK) {
            return false;
        }
        if (!this.consumeFavor(player)) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)player;
        EntityPlayerMP entityPlayerMP = targetPlayer;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"targetPlayer");
        BlockPos blockPos2 = entityPlayerMP.func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"targetPlayer.position");
        UtilEntity.INSTANCE.teleport(entityLivingBase, dimension, blockPos2);
        if (this.getConsumeOnUse()) {
            stack2.func_190918_g(1);
        }
        return true;
    }

    private final boolean consumeFavor(EntityPlayer player) {
        if (this.getFavorCost() == 0) {
            return true;
        }
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        return spiritData.consumeFavor(this.getSpirit().getId(), this.getFavorCost());
    }

    public void func_77624_a(@NotNull ItemStack stack2, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        super.func_77624_a(stack2, world, tooltip, flag);
        if (ItemStackExtensionsKt.isPropertySet(stack2, playerName)) {
            String string = I18n.func_135052_a((String)"item.divinefavor:contract.player", (Object[])new Object[]{ItemStackExtensionsKt.get(stack2, playerName)});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"item.divine\u2026\", stack.get(playerName))");
            tooltip.add(string);
        }
    }

    @Override
    @NotNull
    public ItemStack getSelectedStack(@NotNull ItemStack stack2) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        return stack2;
    }

    @Override
    public boolean getConsumeOnUse() {
        return this.consumeOnUse;
    }

    @Override
    public int getFavorCost() {
        return this.favorCost;
    }

    @Override
    @NotNull
    public ModSpirit getSpirit() {
        return this.spirit;
    }

    public ItemInviteMarker(@NotNull String name, boolean canTeleportToDimensions, boolean consumeOnUse, int favorCost, @NotNull ModSpirit spirit, int maxStackSize) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        super(name, name, ConstGemTabOrder.INSTANCE.getOTHER_GEMS());
        this.canTeleportToDimensions = canTeleportToDimensions;
        this.consumeOnUse = consumeOnUse;
        this.favorCost = favorCost;
        this.spirit = spirit;
        this.properties = propertyHandler;
        this.func_77625_d(maxStackSize);
        this.func_77637_a(DivineFavor.INSTANCE.getTAB_GEMS());
    }

    static {
        Companion = new Companion(null);
        propertyHandler = new StackPropertyHandler(null, null, 3, null);
        maskItemId = (StackPropertyString)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemId());
        maskItemMeta = (StackPropertyInt)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemMeta());
        playerId = StackPropertyHandler.registerUUIDProperty$default(propertyHandler, "PlayerUUID", EmptyConst.INSTANCE.invalidUUID(), false, false, 0, 28, null);
        playerName = StackPropertyHandler.registerStringProperty$default(propertyHandler, "PlayerName", "", false, false, 0, 28, null);
    }

    @Override
    @Nullable
    public Pair<ItemStack, StackProperty<? extends Object>> findProperty(@NotNull ItemStack stack2, @NotNull Item item, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return IStackUsableGemItem.DefaultImpls.findProperty(this, stack2, item, propertyName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/item/gems/ItemInviteMarker$Companion;", "", "()V", "maskItemId", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "getMaskItemId", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "maskItemMeta", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "getMaskItemMeta", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "playerId", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyUUID;", "getPlayerId", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyUUID;", "playerName", "getPlayerName", "propertyHandler", "Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "getPropertyHandler", "()Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final StackPropertyHandler getPropertyHandler() {
            return propertyHandler;
        }

        @NotNull
        public final StackPropertyString getMaskItemId() {
            return maskItemId;
        }

        @NotNull
        public final StackPropertyInt getMaskItemMeta() {
            return maskItemMeta;
        }

        @NotNull
        public final StackPropertyUUID getPlayerId() {
            return playerId;
        }

        @NotNull
        public final StackPropertyString getPlayerName() {
            return playerName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

