/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item.gems;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.constants.ConstGemTabOrder;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.item.gems.base.IStackUsableGemItem;
import aurocosh.divinefavor.common.item.gems.properties.GemMaskProperties;
import aurocosh.divinefavor.common.item.gems.properties.GemPositionProperties;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContext;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContextGenerator;
import aurocosh.divinefavor.common.item.talisman.ISelectedStackProvider;
import aurocosh.divinefavor.common.lib.extensions.ItemStackExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.stack_properties.StackPropertyHandler;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyAccessor;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyContainer;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyBlockPos;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyInt;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyString;
import aurocosh.divinefavor.common.stack_properties.properties.base.StackProperty;
import aurocosh.divinefavor.common.util.UtilEntity;
import aurocosh.divinefavor.common.util.UtilItemStack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00013B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016JH\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Laurocosh/divinefavor/common/item/gems/ItemWarpMarker;", "Laurocosh/divinefavor/common/item/base/ModItem;", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyContainer;", "Laurocosh/divinefavor/common/item/gems/base/IStackUsableGemItem;", "Laurocosh/divinefavor/common/item/talisman/ISelectedStackProvider;", "name", "", "canTeleportToDimensions", "", "consumeOnUse", "favorCost", "", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "maxStackSize", "(Ljava/lang/String;ZZILaurocosh/divinefavor/common/spirit/base/ModSpirit;I)V", "getConsumeOnUse", "()Z", "getFavorCost", "()I", "properties", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getProperties", "()Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getSpirit", "()Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "cast", "context", "Laurocosh/divinefavor/common/item/spell_talismans/context/CastContext;", "consumeFavor", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getSelectedStack", "Lnet/minecraft/item/ItemStack;", "stack", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "pos", "Lnet/minecraft/util/math/BlockPos;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "Companion", "divinefavor"})
public final class ItemWarpMarker
extends ModItem
implements IStackPropertyContainer,
IStackUsableGemItem,
ISelectedStackProvider {
    @NotNull
    private final IStackPropertyAccessor properties;
    private final boolean canTeleportToDimensions;
    private final boolean consumeOnUse;
    private final int favorCost;
    @NotNull
    private final ModSpirit spirit;
    @NotNull
    private static final StackPropertyHandler propertyHandler;
    @NotNull
    private static final StackPropertyBlockPos position;
    @NotNull
    private static final StackPropertyInt dimension;
    @NotNull
    private static final StackPropertyString maskItemId;
    @NotNull
    private static final StackPropertyInt maskItemMeta;
    public static final Companion Companion;

    @Override
    @NotNull
    public IStackPropertyAccessor getProperties() {
        return this.properties;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand2) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.rightClick(world, player, hand2, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResult(result, stack2);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumHand hand2, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.useCast(player, world, pos2, hand2, facing, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResultPass(result);
    }

    @Override
    public boolean cast(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ItemStack stack2 = context.getStack();
        if (stack2.func_190926_b()) {
            return false;
        }
        if (!(stack2.func_77973_b() instanceof ItemWarpMarker)) {
            return false;
        }
        if (!ItemStackExtensionsKt.isPropertySet(stack2, position)) {
            return false;
        }
        EntityPlayer player = context.getPlayer();
        int dimension = ((Number)ItemStackExtensionsKt.get(stack2, ItemWarpMarker.dimension)).intValue();
        if (!this.canTeleportToDimensions && dimension != player.field_71093_bK) {
            return false;
        }
        if (!this.consumeFavor(player)) {
            return false;
        }
        if (context.getWorld().field_72995_K) {
            return false;
        }
        BlockPos destination = (BlockPos)ItemStackExtensionsKt.get(stack2, position);
        UtilEntity.INSTANCE.teleport((EntityLivingBase)player, dimension, destination);
        if (this.getConsumeOnUse()) {
            stack2.func_190918_g(1);
        }
        return true;
    }

    private final boolean consumeFavor(EntityPlayer player) {
        if (this.getFavorCost() == 0) {
            return true;
        }
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        return spiritData.consumeFavor(this.getSpirit().getId(), this.getFavorCost());
    }

    @Override
    @NotNull
    public ItemStack getSelectedStack(@NotNull ItemStack stack2) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        return stack2;
    }

    @Override
    public boolean getConsumeOnUse() {
        return this.consumeOnUse;
    }

    @Override
    public int getFavorCost() {
        return this.favorCost;
    }

    @Override
    @NotNull
    public ModSpirit getSpirit() {
        return this.spirit;
    }

    public ItemWarpMarker(@NotNull String name, boolean canTeleportToDimensions, boolean consumeOnUse, int favorCost, @NotNull ModSpirit spirit, int maxStackSize) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        super(name, name, ConstGemTabOrder.INSTANCE.getOTHER_GEMS());
        this.canTeleportToDimensions = canTeleportToDimensions;
        this.consumeOnUse = consumeOnUse;
        this.favorCost = favorCost;
        this.spirit = spirit;
        this.properties = propertyHandler;
        this.func_77625_d(maxStackSize);
        this.func_77637_a(DivineFavor.INSTANCE.getTAB_GEMS());
    }

    static {
        Companion = new Companion(null);
        propertyHandler = new StackPropertyHandler(null, null, 3, null);
        position = (StackPropertyBlockPos)propertyHandler.registerProperty((StackProperty)GemPositionProperties.INSTANCE.getPosition());
        dimension = (StackPropertyInt)propertyHandler.registerProperty((StackProperty)GemPositionProperties.INSTANCE.getDimension());
        maskItemId = (StackPropertyString)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemId());
        maskItemMeta = (StackPropertyInt)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemMeta());
    }

    @Override
    @Nullable
    public Pair<ItemStack, StackProperty<? extends Object>> findProperty(@NotNull ItemStack stack2, @NotNull Item item, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return IStackPropertyContainer.DefaultImpls.findProperty(this, stack2, item, propertyName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/item/gems/ItemWarpMarker$Companion;", "", "()V", "dimension", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "getDimension", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "maskItemId", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "getMaskItemId", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "maskItemMeta", "getMaskItemMeta", "position", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBlockPos;", "getPosition", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBlockPos;", "propertyHandler", "Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "getPropertyHandler", "()Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final StackPropertyHandler getPropertyHandler() {
            return propertyHandler;
        }

        @NotNull
        public final StackPropertyBlockPos getPosition() {
            return position;
        }

        @NotNull
        public final StackPropertyInt getDimension() {
            return dimension;
        }

        @NotNull
        public final StackPropertyString getMaskItemId() {
            return maskItemId;
        }

        @NotNull
        public final StackPropertyInt getMaskItemMeta() {
            return maskItemMeta;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

