/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item.gems.storage;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.constants.ConstGemTabOrder;
import aurocosh.divinefavor.common.constants.FacingConstants;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.item.gems.base.IStackUsableGemItem;
import aurocosh.divinefavor.common.item.gems.properties.GemMaskProperties;
import aurocosh.divinefavor.common.item.gems.properties.GemPositionProperties;
import aurocosh.divinefavor.common.item.gems.storage.StorageGemInventoryWrapper;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContext;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContextGenerator;
import aurocosh.divinefavor.common.item.talisman.ISelectedStackProvider;
import aurocosh.divinefavor.common.lib.extensions.ItemStackExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.stack_properties.StackPropertyHandler;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyAccessor;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyContainer;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyBlockPos;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyInt;
import aurocosh.divinefavor.common.stack_properties.properties.StackPropertyString;
import aurocosh.divinefavor.common.stack_properties.properties.base.StackProperty;
import aurocosh.divinefavor.common.util.UtilItemStack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00016B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J&\u0010*\u001a\b\u0012\u0004\u0012\u00020(0+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0016JH\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Laurocosh/divinefavor/common/item/gems/storage/ItemStorageGem;", "Laurocosh/divinefavor/common/item/base/ModItem;", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyContainer;", "Laurocosh/divinefavor/common/item/gems/base/IStackUsableGemItem;", "Laurocosh/divinefavor/common/item/talisman/ISelectedStackProvider;", "name", "", "consumeOnUse", "", "favorCost", "", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "maxStackSize", "(Ljava/lang/String;ZILaurocosh/divinefavor/common/spirit/base/ModSpirit;I)V", "getConsumeOnUse", "()Z", "getFavorCost", "()I", "properties", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getProperties", "()Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getSpirit", "()Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "cast", "context", "Laurocosh/divinefavor/common/item/spell_talismans/context/CastContext;", "consumeFavor", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "findConnectedChest", "Lnet/minecraft/util/EnumFacing;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getContainer", "Lnet/minecraft/world/ILockableContainer;", "getSelectedStack", "Lnet/minecraft/item/ItemStack;", "stack", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "facing", "hitX", "", "hitY", "hitZ", "Companion", "divinefavor"})
public final class ItemStorageGem
extends ModItem
implements IStackPropertyContainer,
IStackUsableGemItem,
ISelectedStackProvider {
    @NotNull
    private final IStackPropertyAccessor properties;
    private final boolean consumeOnUse;
    private final int favorCost;
    @NotNull
    private final ModSpirit spirit;
    @NotNull
    private static final StackPropertyHandler propertyHandler;
    @NotNull
    private static final StackPropertyBlockPos position;
    @NotNull
    private static final StackPropertyInt dimension;
    @NotNull
    private static final StackPropertyString maskItemId;
    @NotNull
    private static final StackPropertyInt maskItemMeta;
    public static final Companion Companion;

    @Override
    @NotNull
    public IStackPropertyAccessor getProperties() {
        return this.properties;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand2) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.rightClick(world, player, hand2, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResult(result, stack2);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumHand hand2, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack itemStack = stack2 = player.func_184586_b(hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        CastContext context = CastContextGenerator.INSTANCE.useCast(player, world, pos2, hand2, facing, itemStack, stack2);
        boolean result = this.cast(context);
        return UtilItemStack.INSTANCE.actionResultPass(result);
    }

    @Override
    public boolean cast(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ItemStack stack2 = context.getStack();
        if (stack2.func_190926_b()) {
            return false;
        }
        if (!(stack2.func_77973_b() instanceof ItemStorageGem)) {
            return false;
        }
        if (!ItemStackExtensionsKt.isPropertySet(stack2, position)) {
            return false;
        }
        World world = context.getWorld();
        EntityPlayer player = context.getPlayer();
        int dimension = ((Number)ItemStackExtensionsKt.get(stack2, ItemStorageGem.dimension)).intValue();
        if (dimension != player.field_71093_bK) {
            return false;
        }
        if (!this.consumeFavor(player)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        BlockPos pos2 = (BlockPos)ItemStackExtensionsKt.get(stack2, position);
        ILockableContainer iLockableContainer = this.getContainer(world, pos2);
        if (iLockableContainer == null) {
            return false;
        }
        ILockableContainer iLockableContainer2 = iLockableContainer;
        player.func_71007_a((IInventory)new StorageGemInventoryWrapper((IInventory)iLockableContainer2));
        player.func_71029_a(StatList.field_188063_ac);
        if (this.getConsumeOnUse()) {
            stack2.func_190918_g(1);
        }
        return true;
    }

    private final boolean consumeFavor(EntityPlayer player) {
        if (this.getFavorCost() == 0) {
            return true;
        }
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        return spiritData.consumeFavor(this.getSpirit().getId(), this.getFavorCost());
    }

    private final ILockableContainer getContainer(World worldIn, BlockPos pos2) {
        ILockableContainer iLockableContainer;
        TileEntity tileEntity = worldIn.func_175625_s(pos2);
        if (!(tileEntity instanceof TileEntityChest)) {
            tileEntity = null;
        }
        TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
        if (tileEntityChest == null) {
            return null;
        }
        TileEntityChest tileEntity2 = tileEntityChest;
        if (tileEntity2.func_145980_j() != BlockChest.Type.BASIC) {
            return null;
        }
        EnumFacing enumFacing = this.findConnectedChest(worldIn, pos2);
        if (enumFacing == null) {
            return (ILockableContainer)tileEntity2;
        }
        EnumFacing connectedFacing = enumFacing;
        BlockPos connectedPos = pos2.func_177972_a(connectedFacing);
        TileEntity tileMergedChest = worldIn.func_175625_s(connectedPos);
        if (connectedFacing != EnumFacing.WEST && connectedFacing != EnumFacing.NORTH) {
            TileEntity tileEntity3 = tileMergedChest;
            if (tileEntity3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.tileentity.TileEntityChest");
            }
            iLockableContainer = (ILockableContainer)new InventoryLargeChest("container.chestDouble", (ILockableContainer)tileEntity2, (ILockableContainer)((TileEntityChest)tileEntity3));
        } else {
            TileEntity tileEntity4 = tileMergedChest;
            if (tileEntity4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.tileentity.TileEntityChest");
            }
            iLockableContainer = (ILockableContainer)new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityChest)tileEntity4), (ILockableContainer)tileEntity2);
        }
        return iLockableContainer;
    }

    private final EnumFacing findConnectedChest(World worldIn, BlockPos pos2) {
        for (EnumFacing facing : FacingConstants.INSTANCE.getHorizontal()) {
            BlockPos blockPos2 = pos2.func_177972_a(facing);
            IBlockState iBlockState = worldIn.func_180495_p(blockPos2);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(blockPos)");
            Block block = iBlockState.func_177230_c();
            if (block != Blocks.field_150486_ae) continue;
            return facing;
        }
        return null;
    }

    @Override
    @NotNull
    public ItemStack getSelectedStack(@NotNull ItemStack stack2) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        return stack2;
    }

    @Override
    public boolean getConsumeOnUse() {
        return this.consumeOnUse;
    }

    @Override
    public int getFavorCost() {
        return this.favorCost;
    }

    @Override
    @NotNull
    public ModSpirit getSpirit() {
        return this.spirit;
    }

    public ItemStorageGem(@NotNull String name, boolean consumeOnUse, int favorCost, @NotNull ModSpirit spirit, int maxStackSize) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        super(name, name, ConstGemTabOrder.INSTANCE.getOTHER_GEMS());
        this.consumeOnUse = consumeOnUse;
        this.favorCost = favorCost;
        this.spirit = spirit;
        this.properties = propertyHandler;
        this.func_77625_d(maxStackSize);
        this.func_77637_a(DivineFavor.INSTANCE.getTAB_GEMS());
    }

    static {
        Companion = new Companion(null);
        propertyHandler = new StackPropertyHandler(null, null, 3, null);
        position = (StackPropertyBlockPos)propertyHandler.registerProperty((StackProperty)GemPositionProperties.INSTANCE.getPosition());
        dimension = (StackPropertyInt)propertyHandler.registerProperty((StackProperty)GemPositionProperties.INSTANCE.getDimension());
        maskItemId = (StackPropertyString)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemId());
        maskItemMeta = (StackPropertyInt)propertyHandler.registerProperty((StackProperty)GemMaskProperties.INSTANCE.getMaskItemMeta());
    }

    @Override
    @Nullable
    public Pair<ItemStack, StackProperty<? extends Object>> findProperty(@NotNull ItemStack stack2, @NotNull Item item, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return IStackPropertyContainer.DefaultImpls.findProperty(this, stack2, item, propertyName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/item/gems/storage/ItemStorageGem$Companion;", "", "()V", "dimension", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "getDimension", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyInt;", "maskItemId", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "getMaskItemId", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyString;", "maskItemMeta", "getMaskItemMeta", "position", "Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBlockPos;", "getPosition", "()Laurocosh/divinefavor/common/stack_properties/properties/StackPropertyBlockPos;", "propertyHandler", "Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "getPropertyHandler", "()Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final StackPropertyHandler getPropertyHandler() {
            return propertyHandler;
        }

        @NotNull
        public final StackPropertyBlockPos getPosition() {
            return position;
        }

        @NotNull
        public final StackPropertyInt getDimension() {
            return dimension;
        }

        @NotNull
        public final StackPropertyString getMaskItemId() {
            return maskItemId;
        }

        @NotNull
        public final StackPropertyInt getMaskItemMeta() {
            return maskItemMeta;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

