/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.item.talisman;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.item.base.ICastable;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.item.spell_talismans.base.CastType;
import aurocosh.divinefavor.common.item.spell_talismans.context.CastContext;
import aurocosh.divinefavor.common.item.talisman.ISelectedStackProvider;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.lib.interfaces.IBlockCatcher;
import aurocosh.divinefavor.common.network.message.client.spirit_data.MessageSyncFavor;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import aurocosh.divinefavor.common.stack_actions.StackAction;
import aurocosh.divinefavor.common.stack_actions.StackActionHandler;
import aurocosh.divinefavor.common.stack_actions.interfaces.IActionAccessor;
import aurocosh.divinefavor.common.stack_actions.interfaces.IActionContainer;
import aurocosh.divinefavor.common.stack_properties.StackPropertyHandler;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyAccessor;
import aurocosh.divinefavor.common.stack_properties.interfaces.IStackPropertyContainer;
import aurocosh.divinefavor.common.stack_properties.properties.base.StackProperty;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ0\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0.2\u0006\u0010/\u001a\u000200H\u0017J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J \u00105\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00106\u001a\u00020*2\u0006\u00107\u001a\u000208H\u0016J\u000e\u00109\u001a\u0002022\u0006\u00103\u001a\u000204J\u0010\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020*H\u0016J\u0010\u0010<\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010?\u001a\u00020*2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010)\u001a\u00020*H\u0007J\u0018\u0010C\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u0010D\u001a\u00020EH\u0017J\u0010\u0010F\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010G\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010H\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010I\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010J\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\u0018\u0010K\u001a\u0002022\u0006\u0010)\u001a\u00020*2\u0006\u0010L\u001a\u00020MH\u0016J\u0018\u0010N\u001a\u0002022\u0006\u0010)\u001a\u00020*2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010O\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\u0010\u0010P\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018\u00a8\u0006Q"}, d2={"Laurocosh/divinefavor/common/item/talisman/ItemTalisman;", "Laurocosh/divinefavor/common/item/base/ModItem;", "Laurocosh/divinefavor/common/item/talisman/ISelectedStackProvider;", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyContainer;", "Laurocosh/divinefavor/common/stack_actions/interfaces/IActionContainer;", "Laurocosh/divinefavor/common/lib/interfaces/IBlockCatcher;", "Laurocosh/divinefavor/common/item/base/ICastable;", "name", "", "texturePath", "spirit", "Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "favorCost", "", "(Ljava/lang/String;Ljava/lang/String;Laurocosh/divinefavor/common/spirit/base/ModSpirit;I)V", "actionHandler", "Laurocosh/divinefavor/common/stack_actions/StackActionHandler;", "getActionHandler", "()Laurocosh/divinefavor/common/stack_actions/StackActionHandler;", "actions", "Laurocosh/divinefavor/common/stack_actions/interfaces/IActionAccessor;", "getActions", "()Laurocosh/divinefavor/common/stack_actions/interfaces/IActionAccessor;", "getFavorCost", "()I", "getName", "()Ljava/lang/String;", "properties", "Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "getProperties", "()Laurocosh/divinefavor/common/stack_properties/interfaces/IStackPropertyAccessor;", "propertyHandler", "Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "getPropertyHandler", "()Laurocosh/divinefavor/common/stack_properties/StackPropertyHandler;", "getSpirit", "()Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "spiritId", "getSpiritId", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "cast", "", "context", "Laurocosh/divinefavor/common/item/spell_talismans/context/CastContext;", "catchDrops", "toolStack", "event", "Lnet/minecraftforge/event/world/BlockEvent$HarvestDropsEvent;", "claimCost", "getApproximateFavorCost", "itemStack", "getFinalFavorCost", "getRarity", "Lnet/minecraft/item/EnumRarity;", "getSelectedStack", "getUseInfo", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "handleRendering", "lastEvent", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "isConsumeCharge", "performActionClient", "performActionServer", "preProcess", "preValidate", "raycastBlock", "castType", "Laurocosh/divinefavor/common/item/spell_talismans/base/CastType;", "raycastTarget", "shouldRender", "validate", "divinefavor"})
public abstract class ItemTalisman
extends ModItem
implements ISelectedStackProvider,
IStackPropertyContainer,
IActionContainer,
IBlockCatcher,
ICastable {
    @NotNull
    private final StackPropertyHandler propertyHandler;
    @NotNull
    private final IStackPropertyAccessor properties;
    @NotNull
    private final StackActionHandler actionHandler;
    @NotNull
    private final IActionAccessor actions;
    @NotNull
    private final String name;
    @NotNull
    private final ModSpirit spirit;
    private final int favorCost;

    @NotNull
    protected final StackPropertyHandler getPropertyHandler() {
        return this.propertyHandler;
    }

    @Override
    @NotNull
    public IStackPropertyAccessor getProperties() {
        return this.properties;
    }

    @NotNull
    protected final StackActionHandler getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @NotNull
    public IActionAccessor getActions() {
        return this.actions;
    }

    public final int getSpiritId() {
        return this.spirit.getId();
    }

    public int getApproximateFavorCost(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        return this.favorCost;
    }

    public int getFinalFavorCost(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.favorCost;
    }

    @Override
    public boolean cast(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.getStackValid()) {
            return false;
        }
        if (!this.preValidate(context)) {
            return false;
        }
        if (!this.preProcess(context)) {
            return false;
        }
        if (!this.validate(context)) {
            return false;
        }
        if (this.isConsumeCharge(context) && !this.claimCost(context)) {
            return false;
        }
        if (context.getWorld().field_72995_K) {
            this.performActionClient(context);
        } else {
            this.performActionServer(context);
        }
        return true;
    }

    public final boolean claimCost(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        EntityPlayer player = context.getPlayer();
        int trueCost = this.getFinalFavorCost(context);
        if (trueCost == 0) {
            return true;
        }
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        if (!spiritData.consumeFavor(this.spirit.getId(), trueCost)) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        new MessageSyncFavor(this.spirit, spiritData).sendTo(player);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final String getUseInfo(@NotNull EntityPlayer player, @NotNull ItemStack stack2) {
        String description;
        int useCount;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        int favorValue = spiritData.getFavor(this.spirit.getId());
        int trueFavorCost = this.getApproximateFavorCost(stack2);
        boolean infinite = spiritData.isFavorInfinite(this.spirit.getId()) || trueFavorCost == 0;
        int n = useCount = infinite ? -1 : favorValue / trueFavorCost;
        if (useCount < 0) {
            String string = I18n.func_135052_a((String)"tooltip.divinefavor:talisman.infinite_use", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"tooltip.div\u2026r:talisman.infinite_use\")");
            description = string;
        } else if (useCount == 0) {
            String string = I18n.func_135052_a((String)"tooltip.divinefavor:talisman.unusable", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"tooltip.div\u2026favor:talisman.unusable\")");
            description = string;
        } else {
            String string = I18n.func_135052_a((String)"tooltip.divinefavor:talisman.cost", (Object[])new Object[]{trueFavorCost, useCount});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"tooltip.div\u2026 trueFavorCost, useCount)");
            description = string;
        }
        return description;
    }

    @NotNull
    public EnumRarity func_77613_e(@NotNull ItemStack stack2) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack2, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        String message;
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        super.func_77624_a(stack2, world, tooltip, flag);
        if (!DivineFavor.INSTANCE.getProxy().getHasClientPlayer()) {
            return;
        }
        EntityPlayer player = DivineFavor.INSTANCE.getProxy().getClientPlayer();
        Item item = stack2.func_77973_b();
        if (item == null) {
            throw new TypeCastException("null cannot be cast to non-null type aurocosh.divinefavor.common.item.talisman.ItemTalisman");
        }
        ItemTalisman talisman = (ItemTalisman)item;
        String favorCost = talisman.getUseInfo(player, stack2);
        tooltip.add(favorCost);
        ModSpirit spirit = talisman.spirit;
        String name = I18n.func_135052_a((String)spirit.getNameTranslationKey(), (Object[])new Object[0]);
        String string = message = I18n.func_135052_a((String)"tooltip.divinefavor:talisman.spirit", (Object[])new Object[]{name});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        tooltip.add(string);
        Iterable $receiver$iv = this.getProperties().getPropertyTooltip(stack2);
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            tooltip.add(it);
        }
    }

    protected boolean preValidate(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return !this.raycastBlock(context.getStack(), context.getCastType()) || context.getRaycastValid();
    }

    protected boolean preProcess(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return true;
    }

    protected boolean validate(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return true;
    }

    protected boolean isConsumeCharge(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return true;
    }

    public boolean raycastBlock(@NotNull ItemStack stack2, @NotNull CastType castType) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)castType), (String)"castType");
        return false;
    }

    public boolean raycastTarget(@NotNull ItemStack stack2, @NotNull CastType castType) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)castType), (String)"castType");
        return false;
    }

    protected void performActionServer(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    protected void performActionClient(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender(@NotNull CastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleRendering(@NotNull CastContext context, @NotNull RenderWorldLastEvent lastEvent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)lastEvent, (String)"lastEvent");
    }

    @Override
    public void catchDrops(@NotNull ItemStack stack2, @NotNull ItemStack toolStack, @NotNull BlockEvent.HarvestDropsEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)toolStack, (String)"toolStack");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
    }

    @Override
    @NotNull
    public ItemStack getSelectedStack(@NotNull ItemStack stack2) {
        ItemStack itemStack;
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        if (stack2.func_77973_b() instanceof ItemTalisman) {
            itemStack = stack2;
        } else {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ModSpirit getSpirit() {
        return this.spirit;
    }

    protected final int getFavorCost() {
        return this.favorCost;
    }

    public ItemTalisman(@NotNull String name, @NotNull String texturePath, @NotNull ModSpirit spirit, int favorCost) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)texturePath, (String)"texturePath");
        Intrinsics.checkParameterIsNotNull((Object)spirit, (String)"spirit");
        super(name, texturePath, 0, 4, null);
        this.name = name;
        this.spirit = spirit;
        this.favorCost = favorCost;
        this.propertyHandler = new StackPropertyHandler("talisman " + this.name, null, 2, null);
        this.properties = this.propertyHandler;
        this.actionHandler = new StackActionHandler("talisman " + this.name);
        this.actions = this.actionHandler;
        this.func_77625_d(1);
    }

    @Override
    @Nullable
    public Pair<ItemStack, StackProperty<? extends Object>> findProperty(@NotNull ItemStack stack2, @NotNull Item item, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return IStackPropertyContainer.DefaultImpls.findProperty(this, stack2, item, propertyName);
    }

    @Override
    @Nullable
    public Pair<ItemStack, StackAction> findAction(@NotNull ItemStack stack2, @NotNull Item item, @NotNull String actionName) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)actionName, (String)"actionName");
        return IActionContainer.DefaultImpls.findAction(this, stack2, item, actionName);
    }
}

