/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\t\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0016J\u001f\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/lib/LimitedMap;", "K", "V", "Ljava/util/HashMap;", "maxCapacity", "", "(I)V", "additionOrder", "Ljava/util/LinkedList;", "put", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "", "from", "", "putIfAbsent", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", "removeExcess", "divinefavor"})
public final class LimitedMap<K, V>
extends HashMap<K, V> {
    private final LinkedList<K> additionOrder;
    private final int maxCapacity;

    @Override
    @Nullable
    public V remove(Object key) {
        Object value = super.remove(key);
        this.additionOrder.remove(key);
        return value;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.additionOrder.add(key);
        V result = super.put(key, value);
        this.removeExcess();
        return result;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        this.additionOrder.addAll((Collection)from.keySet());
        super.putAll(from);
        this.removeExcess();
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            this.additionOrder.add(key);
        }
        V result = super.putIfAbsent(key, value);
        this.removeExcess();
        return result;
    }

    private final void removeExcess() {
        while (this.size() > this.maxCapacity) {
            this.remove(this.additionOrder.removeLast());
        }
    }

    public LimitedMap(int maxCapacity) {
        super(maxCapacity);
        this.maxCapacity = maxCapacity;
        this.additionOrder = new LinkedList();
    }
}

