/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.util.UtilReflection;
import java.lang.reflect.Field;

public class PrivateField<T, K> {
    private final Field field;
    private Class<T> classToAccess;
    private final K fallbackValue;

    public PrivateField(Class<T> classToAccess, int fieldIndex, K fallbackValue) {
        this.classToAccess = classToAccess;
        this.fallbackValue = fallbackValue;
        this.field = UtilReflection.getPrivateField(classToAccess, fieldIndex);
        if (this.field != null && !this.field.getType().equals(fallbackValue.getClass())) {
            DivineFavor.logger.error("Reflected private field {} on class {} value type {} is not equal to expected value type {}", (Object)this.field.getName(), (Object)classToAccess.getName(), (Object)this.field.getType().getName(), (Object)fallbackValue.getClass().getName());
        }
    }

    public K get(T instance) {
        if (this.field == null) {
            return this.fallbackValue;
        }
        try {
            return (K)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            DivineFavor.logger.error("Unable to access any field {} on type {} with type {}", (Object)this.field.getName(), (Object)this.classToAccess.getName(), (Object)e);
            e.printStackTrace();
            return this.fallbackValue;
        }
    }
}

