/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib.coordinates;

import aurocosh.divinefavor.common.constants.BlockPosConstants;
import aurocosh.divinefavor.common.lib.coordinates.FloodFiller;
import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.util.UtilPredicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JF\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Laurocosh/divinefavor/common/lib/coordinates/SurfaceFloodFiller;", "Laurocosh/divinefavor/common/lib/coordinates/FloodFiller;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "airPositions", "Ljava/util/HashSet;", "Lnet/minecraft/util/math/BlockPos;", "Lkotlin/collections/HashSet;", "airState", "Lnet/minecraft/block/state/IBlockState;", "kotlin.jvm.PlatformType", "solidPositions", "floodFill", "", "start", "", "expansionDirs", "predicate", "Lkotlin/Function1;", "", "limit", "", "isSolid", "pos", "isValid", "reset", "", "divinefavor"})
public final class SurfaceFloodFiller
extends FloodFiller {
    private final IBlockState airState;
    private final HashSet<BlockPos> airPositions;
    private final HashSet<BlockPos> solidPositions;
    private final World world;

    @Override
    public void reset() {
        super.reset();
        this.airPositions.clear();
        this.solidPositions.clear();
    }

    @Override
    @NotNull
    public List<BlockPos> floodFill(@NotNull Collection<? extends BlockPos> start, @NotNull Collection<? extends BlockPos> expansionDirs, @NotNull Function1<? super BlockPos, Boolean> predicate2, int limit) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(expansionDirs, (String)"expansionDirs");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        Function1 combinedPredicate2 = UtilPredicate.INSTANCE.and(predicate2, (Function1)new Function1<BlockPos, Boolean>(this){

            public final boolean invoke(@NotNull BlockPos p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SurfaceFloodFiller.access$isValid((SurfaceFloodFiller)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SurfaceFloodFiller.class);
            }

            public final String getName() {
                return "isValid";
            }

            public final String getSignature() {
                return "isValid(Lnet/minecraft/util/math/BlockPos;)Z";
            }
        });
        return super.floodFill(start, expansionDirs, combinedPredicate2, limit);
    }

    private final boolean isValid(BlockPos pos2) {
        boolean bl;
        block2: {
            if (!this.isSolid(pos2)) {
                return false;
            }
            Sequence $receiver$iv = SequencesKt.map(IterableExtensionsKt.getS((Iterable)BlockPosConstants.INSTANCE.getDIRECT_NEIGHBOURS()), (Function1)((Function1)new Function1<Vec3i, BlockPos>(pos2){

                public final BlockPos invoke(Vec3i p1) {
                    return ((BlockPos)this.receiver).func_177971_a(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(BlockPos.class);
                }

                public final String getName() {
                    return "add";
                }

                public final String getSignature() {
                    return "add(Lnet/minecraft/util/math/Vec3i;)Lnet/minecraft/util/math/BlockPos;";
                }
            }));
            for (Object element$iv : $receiver$iv) {
                BlockPos it;
                BlockPos blockPos2 = it = (BlockPos)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"it");
                if (!(!this.isSolid(blockPos2))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSolid(BlockPos pos2) {
        if (this.airPositions.contains(pos2)) {
            return false;
        }
        if (this.solidPositions.contains(pos2)) {
            return true;
        }
        IBlockState state2 = this.world.func_180495_p(pos2);
        boolean isAir = Intrinsics.areEqual((Object)state2, (Object)this.airState);
        if (isAir) {
            this.getExplored().add(pos2);
            this.airPositions.add(pos2);
        } else {
            this.solidPositions.add(pos2);
        }
        return !isAir;
    }

    public SurfaceFloodFiller(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        this.world = world;
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
        this.airState = block.func_176223_P();
        this.airPositions = new HashSet();
        this.solidPositions = new HashSet();
    }

    public static final /* synthetic */ boolean access$isValid(SurfaceFloodFiller $this, @NotNull BlockPos pos2) {
        return $this.isValid(pos2);
    }
}

