/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib.extensions;

import aurocosh.divinefavor.common.custom_data.global.GlobalSaveDataId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a8\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002\"\u0010\b\u0001\u0010\u0003\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u0003H\u0086\n\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0011\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0012\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"get", "T", "Lnet/minecraft/world/storage/WorldSavedData;", "K", "Laurocosh/divinefavor/common/custom_data/global/GlobalSaveDataId;", "Lnet/minecraft/world/World;", "globalDataId", "(Lnet/minecraft/world/World;Laurocosh/divinefavor/common/custom_data/global/GlobalSaveDataId;)Lnet/minecraft/world/storage/WorldSavedData;", "getBlock", "Lnet/minecraft/block/Block;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getMaterial", "Lnet/minecraft/block/material/Material;", "hasTileEntity", "", "isAirOrReplacable", "isLeaves", "isWood", "divinefavor"})
public final class WorldExtensionsKt {
    @NotNull
    public static final Block getBlock(@NotNull World $receiver, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        IBlockState iBlockState = $receiver.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"this.getBlockState(pos)");
        Block block = iBlockState.func_177230_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"this.getBlockState(pos).block");
        return block;
    }

    public static final boolean hasTileEntity(@NotNull World $receiver, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        return $receiver.func_175625_s(pos2) != null;
    }

    @NotNull
    public static final Material getMaterial(@NotNull World $receiver, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        IBlockState iBlockState = $receiver.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"this.getBlockState(pos)");
        Material material = iBlockState.func_185904_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"this.getBlockState(pos).material");
        return material;
    }

    public static final boolean isWood(@NotNull World $receiver, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        IBlockState iBlockState = $receiver.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"this.getBlockState(pos)");
        return iBlockState.func_177230_c().isWood((IBlockAccess)$receiver, pos2);
    }

    public static final boolean isLeaves(@NotNull World $receiver, @NotNull BlockPos pos2) {
        IBlockState blockState;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        IBlockState iBlockState = blockState = $receiver.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
        Block block = iBlockState.func_177230_c();
        return block.isLeaves(blockState, (IBlockAccess)$receiver, pos2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAirOrReplacable(@NotNull World $receiver, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if ($receiver.func_175623_d(pos2)) return true;
        IBlockState iBlockState = $receiver.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"this.getBlockState(pos)");
        if (!iBlockState.func_177230_c().func_176200_f((IBlockAccess)$receiver, pos2)) return false;
        return true;
    }

    private static final <T extends WorldSavedData, K extends GlobalSaveDataId<T>> T get(@NotNull World $receiver, K globalDataId) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        MapStorage mapStorage = $receiver.func_175693_T();
        if (mapStorage == null) {
            throw (Throwable)new IllegalStateException("World#getMapStorage returned null. The following WorldSave is inaccessible: " + globalDataId + ".name");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)mapStorage, (String)"this.mapStorage\n        \u2026ble: $globalDataId.name\")");
        MapStorage storage = mapStorage;
        WorldSavedData instance = storage.func_75742_a(globalDataId.getClazz(), globalDataId.getName());
        if (instance != null) {
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)instance;
        }
        T newInstance = globalDataId.makeNewInstance();
        storage.func_75745_a(globalDataId.getName(), newInstance);
        return newInstance;
    }
}

