/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib.math;

import aurocosh.divinefavor.common.constants.BlockPosConstants;
import aurocosh.divinefavor.common.util.UtilBlockPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004J\u0014\u0010\u001e\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006&"}, d2={"Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "", "()V", "firestCorner", "Lnet/minecraft/util/math/BlockPos;", "secondCorner", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V", "allPositionsInside", "", "getAllPositionsInside", "()Ljava/util/List;", "blockCount", "", "getBlockCount", "()I", "lowerCorner", "getLowerCorner", "()Lnet/minecraft/util/math/BlockPos;", "sizeVector", "getSizeVector", "sizeX", "getSizeX", "sizeY", "getSizeY", "sizeZ", "getSizeZ", "upperCorner", "getUpperCorner", "add", "vector", "expandBoundingBox", "positions", "isCoordinateInside", "", "coordinate", "moveToOrigin", "subtract", "Companion", "divinefavor"})
public final class CuboidBoundingBox {
    @NotNull
    private final BlockPos lowerCorner;
    @NotNull
    private final BlockPos upperCorner;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BlockPos getLowerCorner() {
        return this.lowerCorner;
    }

    @NotNull
    public final BlockPos getUpperCorner() {
        return this.upperCorner;
    }

    @NotNull
    public final BlockPos getSizeVector() {
        return new BlockPos(this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }

    public final int getSizeX() {
        return this.upperCorner.func_177958_n() - this.lowerCorner.func_177958_n() + 1;
    }

    public final int getSizeY() {
        return this.upperCorner.func_177956_o() - this.lowerCorner.func_177956_o() + 1;
    }

    public final int getSizeZ() {
        return this.upperCorner.func_177952_p() - this.lowerCorner.func_177952_p() + 1;
    }

    public final int getBlockCount() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BlockPos> getAllPositionsInside() {
        int xSize = this.getSizeX();
        int ySize = this.getSizeY();
        int zSize = this.getSizeZ();
        int positionCount = xSize * ySize * zSize;
        ArrayList<BlockPos> positions2 = new ArrayList<BlockPos>(positionCount);
        int n = 0;
        int n2 = xSize;
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = ySize;
            while (n3 < n4) {
                void y;
                int n5 = 0;
                int n6 = zSize;
                while (n5 < n6) {
                    void z;
                    BlockPos shift = new BlockPos((int)x, (int)y, (int)z);
                    positions2.add(this.lowerCorner.func_177971_a((Vec3i)shift));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return positions2;
    }

    @NotNull
    public final CuboidBoundingBox add(@NotNull BlockPos vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        BlockPos lower = this.lowerCorner.func_177971_a((Vec3i)vector);
        BlockPos upper = this.upperCorner.func_177971_a((Vec3i)vector);
        BlockPos blockPos2 = lower;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"lower");
        BlockPos blockPos3 = upper;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"upper");
        return new CuboidBoundingBox(blockPos2, blockPos3);
    }

    @NotNull
    public final CuboidBoundingBox subtract(@NotNull BlockPos vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        BlockPos blockPos2 = BlockPos.field_177992_a.func_177973_b((Vec3i)vector);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN.subtract(vector)");
        return this.add(blockPos2);
    }

    @NotNull
    public final CuboidBoundingBox moveToOrigin() {
        return this.subtract(this.lowerCorner);
    }

    public final boolean isCoordinateInside(@NotNull BlockPos coordinate) {
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        return this.lowerCorner.func_177958_n() <= coordinate.func_177958_n() && coordinate.func_177958_n() <= this.upperCorner.func_177958_n() && this.lowerCorner.func_177956_o() <= coordinate.func_177956_o() && coordinate.func_177956_o() <= this.upperCorner.func_177956_o() && this.lowerCorner.func_177952_p() <= coordinate.func_177952_p() && coordinate.func_177952_p() <= this.upperCorner.func_177952_p();
    }

    @NotNull
    public final CuboidBoundingBox expandBoundingBox(@NotNull List<? extends BlockPos> positions2) {
        Intrinsics.checkParameterIsNotNull(positions2, (String)"positions");
        return Companion.getBoundingBox(this.lowerCorner, this.upperCorner, (Collection<? extends BlockPos>)positions2);
    }

    public CuboidBoundingBox() {
        BlockPos blockPos2 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN");
        this.lowerCorner = blockPos2;
        BlockPos blockPos3 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"BlockPos.ORIGIN");
        this.upperCorner = blockPos3;
    }

    public CuboidBoundingBox(@NotNull BlockPos firestCorner, @NotNull BlockPos secondCorner) {
        Intrinsics.checkParameterIsNotNull((Object)firestCorner, (String)"firestCorner");
        Intrinsics.checkParameterIsNotNull((Object)secondCorner, (String)"secondCorner");
        int lowerX = Math.min(firestCorner.func_177958_n(), secondCorner.func_177958_n());
        int lowerY = Math.min(firestCorner.func_177956_o(), secondCorner.func_177956_o());
        int lowerZ = Math.min(firestCorner.func_177952_p(), secondCorner.func_177952_p());
        int upperX = Math.max(firestCorner.func_177958_n(), secondCorner.func_177958_n());
        int upperY = Math.max(firestCorner.func_177956_o(), secondCorner.func_177956_o());
        int upperZ = Math.max(firestCorner.func_177952_p(), secondCorner.func_177952_p());
        this.lowerCorner = new BlockPos(lowerX, lowerY, lowerZ);
        this.upperCorner = new BlockPos(upperX, upperY, upperZ);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\n"}, d2={"Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox$Companion;", "", "()V", "getBoundingBox", "Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "positions", "", "Lnet/minecraft/util/math/BlockPos;", "currentMin", "currentMax", "divinefavor"})
    public static final class Companion {
        @NotNull
        public final CuboidBoundingBox getBoundingBox(@NotNull Collection<? extends BlockPos> positions2) {
            Intrinsics.checkParameterIsNotNull(positions2, (String)"positions");
            BlockPos min = BlockPosConstants.INSTANCE.getMAX();
            BlockPos max = BlockPosConstants.INSTANCE.getMIN();
            return this.getBoundingBox(min, max, positions2);
        }

        @NotNull
        public final CuboidBoundingBox getBoundingBox(@NotNull BlockPos currentMin, @NotNull BlockPos currentMax, @NotNull Collection<? extends BlockPos> positions2) {
            Intrinsics.checkParameterIsNotNull((Object)currentMin, (String)"currentMin");
            Intrinsics.checkParameterIsNotNull((Object)currentMax, (String)"currentMax");
            Intrinsics.checkParameterIsNotNull(positions2, (String)"positions");
            BlockPos min = currentMin;
            BlockPos max = currentMax;
            if (positions2.isEmpty()) {
                return new CuboidBoundingBox();
            }
            for (BlockPos blockPos2 : positions2) {
                min = UtilBlockPos.INSTANCE.getMinCoordinates(min, blockPos2);
                max = UtilBlockPos.INSTANCE.getMaxCoordinates(max, blockPos2);
            }
            return new CuboidBoundingBox(min, max);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

