/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.lib.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000J\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006%"}, d2={"Laurocosh/divinefavor/common/lib/math/Vector2i;", "", "n", "", "(I)V", "x", "y", "(II)V", "isZero", "", "()Z", "getX", "()I", "getY", "add", "other", "component1", "component2", "copy", "divide", "value", "dot", "equals", "getMaxCoordinates", "vector", "getMinCoordinates", "hashCode", "inverse", "magnitude", "", "magnitudeSquare", "orthogonal", "scale", "subtract", "vector3i", "toString", "", "divinefavor"})
public final class Vector2i {
    private final int x;
    private final int y;

    public final boolean isZero() {
        return this.x == 0 && this.y == 0;
    }

    @NotNull
    public final Vector2i inverse() {
        return new Vector2i(-this.x, -this.y);
    }

    @NotNull
    public final Vector2i add(@NotNull Vector2i other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vector2i(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vector2i subtract(@NotNull Vector2i vector3i) {
        Intrinsics.checkParameterIsNotNull((Object)vector3i, (String)"vector3i");
        return new Vector2i(this.x - vector3i.x, this.y - vector3i.y);
    }

    @NotNull
    public final Vector2i scale(int value) {
        return new Vector2i(this.x * value, this.y * value);
    }

    @NotNull
    public final Vector2i divide(int value) {
        return new Vector2i(this.x / value, this.y / value);
    }

    public final int dot(@NotNull Vector2i other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y;
    }

    @NotNull
    public final Vector2i getMinCoordinates(@NotNull Vector2i vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        int xMin = Math.min(this.x, vector.x);
        int yMin = Math.min(this.y, vector.y);
        return new Vector2i(xMin, yMin);
    }

    @NotNull
    public final Vector2i getMaxCoordinates(@NotNull Vector2i vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        int xMax = Math.max(this.x, vector.x);
        int yMax = Math.max(this.y, vector.y);
        return new Vector2i(xMax, yMax);
    }

    public final boolean orthogonal(@NotNull Vector2i other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.dot(other) == 0;
    }

    public final double magnitude() {
        return Math.sqrt(this.magnitudeSquare());
    }

    public final int magnitudeSquare() {
        return this.x * this.x + this.y * this.y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(int n) {
        this(n, n);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final Vector2i copy(int x, int y) {
        return new Vector2i(x, y);
    }

    @NotNull
    public static /* synthetic */ Vector2i copy$default(Vector2i vector2i, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = vector2i.x;
        }
        if ((n3 & 2) != 0) {
            n2 = vector2i.y;
        }
        return vector2i.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Vector2i(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector2i)) break block3;
                Vector2i vector2i = (Vector2i)object;
                if (!(this.x == vector2i.x) || !(this.y == vector2i.y)) break block3;
            }
            return true;
        }
        return false;
    }
}

