/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.muliblock;

import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import aurocosh.divinefavor.common.muliblock.MultiBlockPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J\u0006\u0010!\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Laurocosh/divinefavor/common/muliblock/MultiBlockConfiguration;", "", "name", "", "primary", "", "baseRelPosition", "Lnet/minecraft/util/math/BlockPos;", "controllerRelPosition", "parts", "", "Laurocosh/divinefavor/common/muliblock/MultiBlockPart;", "boundingBox", "Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "(Ljava/lang/String;ZLnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Ljava/util/List;Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;)V", "getBaseRelPosition", "()Lnet/minecraft/util/math/BlockPos;", "getBoundingBox", "()Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "boundingBoxRelative", "getBoundingBoxRelative", "getControllerRelPosition", "getName", "()Ljava/lang/String;", "getParts", "()Ljava/util/List;", "getPrimary", "()Z", "getPartsBoundingBox", "isValid", "world", "Lnet/minecraft/world/World;", "controller", "rotateClockwise", "divinefavor"})
public final class MultiBlockConfiguration {
    @NotNull
    private final List<MultiBlockPart> parts;
    @NotNull
    private final String name;
    private final boolean primary;
    @NotNull
    private final BlockPos baseRelPosition;
    @NotNull
    private final BlockPos controllerRelPosition;
    @NotNull
    private final CuboidBoundingBox boundingBox;

    @NotNull
    public final List<MultiBlockPart> getParts() {
        return this.parts;
    }

    @NotNull
    public final CuboidBoundingBox getBoundingBoxRelative() {
        return this.boundingBox.subtract(this.controllerRelPosition);
    }

    public final boolean isValid(@NotNull World world, @NotNull BlockPos controller) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        BlockPos multiBlockOrigin = controller.func_177973_b((Vec3i)this.controllerRelPosition);
        for (MultiBlockPart part : this.parts) {
            BlockPos blockPos2 = multiBlockOrigin;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"multiBlockOrigin");
            if (part.isAllValid(world, blockPos2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final MultiBlockConfiguration rotateClockwise() {
        CuboidBoundingBox boundingBox = this.getPartsBoundingBox(this.parts);
        BlockPos sizeVector = boundingBox.getSizeVector();
        ArrayList<MultiBlockPart> partsNew = new ArrayList<MultiBlockPart>(this.parts.size());
        for (MultiBlockPart part : this.parts) {
            ArrayList<BlockPos> positionsNew = new ArrayList<BlockPos>(part.getPositions().size());
            for (BlockPos position : part.getPositions()) {
                positionsNew.add(new BlockPos(position.func_177952_p(), position.func_177956_o(), sizeVector.func_177958_n() - position.func_177958_n() - 1));
            }
            partsNew.add(new MultiBlockPart(part.getValidator(), (List<? extends BlockPos>)positionsNew));
        }
        BlockPos controllerRelPositionNew = new BlockPos(this.controllerRelPosition.func_177952_p(), this.controllerRelPosition.func_177956_o(), sizeVector.func_177958_n() - this.controllerRelPosition.func_177958_n() - 1);
        CuboidBoundingBox boundingBoxNew = this.getPartsBoundingBox((List<MultiBlockPart>)partsNew);
        return new MultiBlockConfiguration(this.name, false, this.baseRelPosition, controllerRelPositionNew, (List<MultiBlockPart>)partsNew, boundingBoxNew);
    }

    private final CuboidBoundingBox getPartsBoundingBox(List<MultiBlockPart> parts) {
        CuboidBoundingBox boundingBox = new CuboidBoundingBox();
        for (MultiBlockPart part : parts) {
            boundingBox = boundingBox.expandBoundingBox(part.getPositions());
        }
        return boundingBox;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public final BlockPos getBaseRelPosition() {
        return this.baseRelPosition;
    }

    @NotNull
    public final BlockPos getControllerRelPosition() {
        return this.controllerRelPosition;
    }

    @NotNull
    public final CuboidBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public MultiBlockConfiguration(@NotNull String name, boolean primary, @NotNull BlockPos baseRelPosition, @NotNull BlockPos controllerRelPosition, @NotNull List<MultiBlockPart> parts, @NotNull CuboidBoundingBox boundingBox) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)baseRelPosition, (String)"baseRelPosition");
        Intrinsics.checkParameterIsNotNull((Object)controllerRelPosition, (String)"controllerRelPosition");
        Intrinsics.checkParameterIsNotNull(parts, (String)"parts");
        Intrinsics.checkParameterIsNotNull((Object)boundingBox, (String)"boundingBox");
        this.name = name;
        this.primary = primary;
        this.baseRelPosition = baseRelPosition;
        this.controllerRelPosition = controllerRelPosition;
        this.boundingBox = boundingBox;
        List<MultiBlockPart> list2 = Collections.unmodifiableList(parts);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(parts)");
        this.parts = list2;
    }
}

