/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.muliblock.common;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import aurocosh.divinefavor.common.muliblock.ModMultiBlock;
import aurocosh.divinefavor.common.muliblock.MultiBlockConfiguration;
import aurocosh.divinefavor.common.muliblock.MultiBlockPart;
import aurocosh.divinefavor.common.muliblock.serialization.BlockPosToByteSerializer;
import aurocosh.divinefavor.common.muliblock.serialization.MultiBlockData;
import aurocosh.divinefavor.common.muliblock.serialization.StateValidatorSerializer;
import aurocosh.divinefavor.common.muliblock.validators.StateValidator;
import aurocosh.divinefavor.common.util.UtilAssets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007J+\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0013\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/muliblock/common/MultiblockLoader;", "", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "deserializeJson", "Laurocosh/divinefavor/common/muliblock/serialization/MultiBlockData;", "jsonString", "", "generateConfigurations", "", "Laurocosh/divinefavor/common/muliblock/MultiBlockConfiguration;", "name", "data", "load", "Laurocosh/divinefavor/common/muliblock/ModMultiBlock;", "type", "configs", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Laurocosh/divinefavor/common/muliblock/ModMultiBlock;", "divinefavor"})
public final class MultiblockLoader {
    private static final Gson gson;
    public static final MultiblockLoader INSTANCE;

    @NotNull
    public final ModMultiBlock load(@NotNull String type, @NotNull String name, @NotNull String[] configs) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)configs, (String)"configs");
        ArrayList<String> confPaths = new ArrayList<String>();
        String[] stringArray = configs;
        if (stringArray.length == 0) {
            confPaths.add(name);
        }
        ArrayList configurations = new ArrayList(confPaths.size());
        for (String configurationName : confPaths) {
            String jsonString = UtilAssets.INSTANCE.loadTextFile(DivineFavor.INSTANCE.getContainer(), "/assets/divinefavor/multi_blocks/" + type + "/" + configurationName + ".json");
            MultiBlockData data = this.deserializeJson(jsonString);
            configurations.addAll(this.generateConfigurations(type + "_" + configurationName, data));
        }
        return new ModMultiBlock(type + "_" + name, configurations);
    }

    @NotNull
    public final MultiBlockData deserializeJson(@NotNull String jsonString) {
        Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
        MultiBlockData data = null;
        try {
            data = (MultiBlockData)gson.fromJson(jsonString, MultiBlockData.class);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        if (data == null) {
            data = new MultiBlockData();
        }
        return data;
    }

    @NotNull
    public final List<MultiBlockConfiguration> generateConfigurations(@NotNull String name, @NotNull MultiBlockData data) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        ArrayList<BlockPos> localBounds = new ArrayList<BlockPos>();
        for (MultiBlockPart part : data.getParts()) {
            CuboidBoundingBox coordinates2 = CuboidBoundingBox.Companion.getBoundingBox((Collection<? extends BlockPos>)part.getPositions());
            localBounds.add(coordinates2.getLowerCorner());
            localBounds.add(coordinates2.getUpperCorner());
        }
        CuboidBoundingBox boundingBox = CuboidBoundingBox.Companion.getBoundingBox((Collection<? extends BlockPos>)localBounds);
        ArrayList<MultiBlockConfiguration> configurations = new ArrayList<MultiBlockConfiguration>();
        MultiBlockConfiguration configuration = new MultiBlockConfiguration(name, true, data.getBasePosition(), data.getControllerPosition(), data.getParts(), boundingBox);
        configurations.add(configuration);
        if (!data.getSymmetrical()) {
            configuration = configuration.rotateClockwise();
            configurations.add(configuration);
            configuration = configuration.rotateClockwise();
            configurations.add(configuration);
            configuration = configuration.rotateClockwise();
            configurations.add(configuration);
        }
        return configurations;
    }

    private MultiblockLoader() {
    }

    static {
        MultiblockLoader multiblockLoader;
        INSTANCE = multiblockLoader = new MultiblockLoader();
        gson = new GsonBuilder().registerTypeAdapter((Type)((Object)StateValidator.class), (Object)new StateValidatorSerializer()).excludeFieldsWithoutExposeAnnotation().registerTypeAdapter((Type)((Object)BlockPos.class), (Object)new BlockPosToByteSerializer()).create();
    }
}

