/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.muliblock.common;

import aurocosh.divinefavor.common.muliblock.IMultiblockController;
import aurocosh.divinefavor.common.muliblock.instance.MultiBlockInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laurocosh/divinefavor/common/muliblock/common/MultiblockWatcher;", "", "()V", "controllers", "Ljava/util/HashMap;", "Lnet/minecraft/world/World;", "", "Laurocosh/divinefavor/common/muliblock/IMultiblockController;", "getOrMakeControllerSet", "world", "onBreakEvent", "", "event", "Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;", "onPlaceEvent", "Lnet/minecraftforge/event/world/BlockEvent$PlaceEvent;", "registerController", "controller", "unRegisterController", "divinefavor"})
public final class MultiblockWatcher {
    private static final HashMap<World, Set<IMultiblockController>> controllers;
    public static final MultiblockWatcher INSTANCE;

    public final void registerController(@NotNull IMultiblockController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Set<IMultiblockController> controllerSet2 = this.getOrMakeControllerSet(controller.getControllerWorld());
        controllerSet2.add(controller);
    }

    public final void unRegisterController(@NotNull IMultiblockController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Set<IMultiblockController> set = controllers.get(controller.getControllerWorld());
        if (set == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"controllers[controller.g\u2026trollerWorld()] ?: return");
        Set<IMultiblockController> controllerSet2 = set;
        controllerSet2.remove(controller);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onBreakEvent(@NotNull BlockEvent.BreakEvent event) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Set<IMultiblockController> set = controllers.get(event.getWorld());
        if (set == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"controllers[event.world] ?: return");
        Set<IMultiblockController> controllerSet2 = set;
        Collection collection = $receiver$iv = (Collection)controllerSet2;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IMultiblockController[] iMultiblockControllerArray = thisCollection$iv.toArray(new IMultiblockController[0]);
        if (iMultiblockControllerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IMultiblockController[] controllers = iMultiblockControllerArray;
        BlockPos position = event.getPos();
        for (IMultiblockController controller : controllers) {
            MultiBlockInstance multiblockInstance;
            MultiBlockInstance multiBlockInstance = multiblockInstance = controller.getMultiblockInstance();
            if (multiBlockInstance == null) continue;
            BlockPos blockPos2 = position;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"position");
            if (!multiBlockInstance.isSolidPart(blockPos2)) continue;
            EntityPlayer entityPlayer = event.getPlayer();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
            World world = event.getWorld();
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
            BlockPos blockPos3 = event.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"event.pos");
            IBlockState iBlockState = event.getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"event.state");
            controller.multiblockDamaged(entityPlayer, world, blockPos3, iBlockState);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onPlaceEvent(@NotNull BlockEvent.PlaceEvent event) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Set<IMultiblockController> set = controllers.get(event.getWorld());
        if (set == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"controllers[event.world] ?: return");
        Set<IMultiblockController> controllerSet2 = set;
        Collection collection = $receiver$iv = (Collection)controllerSet2;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IMultiblockController[] iMultiblockControllerArray = thisCollection$iv.toArray(new IMultiblockController[0]);
        if (iMultiblockControllerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IMultiblockController[] controllers = iMultiblockControllerArray;
        BlockPos position = event.getPos();
        for (IMultiblockController controller : controllers) {
            MultiBlockInstance multiblockInstance;
            MultiBlockInstance multiBlockInstance = multiblockInstance = controller.getMultiblockInstance();
            if (multiBlockInstance == null) continue;
            BlockPos blockPos2 = position;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"position");
            if (!multiBlockInstance.isSupposedToBeEmpty(blockPos2)) continue;
            EntityPlayer entityPlayer = event.getPlayer();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
            World world = event.getWorld();
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
            BlockPos blockPos3 = event.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"event.pos");
            IBlockState iBlockState = event.getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"event.state");
            controller.multiblockDamaged(entityPlayer, world, blockPos3, iBlockState);
        }
    }

    private final Set<IMultiblockController> getOrMakeControllerSet(World world) {
        Set controllerSet2 = controllers.get(world);
        if (controllerSet2 != null) {
            return controllerSet2;
        }
        controllerSet2 = new HashSet();
        Map map2 = controllers;
        Set set = controllerSet2;
        map2.put(world, set);
        return controllerSet2;
    }

    private MultiblockWatcher() {
    }

    static {
        MultiblockWatcher multiblockWatcher;
        INSTANCE = multiblockWatcher = new MultiblockWatcher();
        controllers = new HashMap();
    }
}

