/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.muliblock.instance;

import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import aurocosh.divinefavor.common.muliblock.ModMultiBlock;
import aurocosh.divinefavor.common.muliblock.MultiBlockConfiguration;
import aurocosh.divinefavor.common.muliblock.MultiBlockPart;
import aurocosh.divinefavor.common.muliblock.validators.AirStateValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001e"}, d2={"Laurocosh/divinefavor/common/muliblock/instance/MultiBlockInstance;", "", "multiBlock", "Laurocosh/divinefavor/common/muliblock/ModMultiBlock;", "configuration", "Laurocosh/divinefavor/common/muliblock/MultiBlockConfiguration;", "controllerPosition", "Lnet/minecraft/util/math/BlockPos;", "(Laurocosh/divinefavor/common/muliblock/ModMultiBlock;Laurocosh/divinefavor/common/muliblock/MultiBlockConfiguration;Lnet/minecraft/util/math/BlockPos;)V", "boundingBox", "Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "getBoundingBox", "()Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "getConfiguration", "()Laurocosh/divinefavor/common/muliblock/MultiBlockConfiguration;", "getMultiBlock", "()Laurocosh/divinefavor/common/muliblock/ModMultiBlock;", "multiBlockOrigin", "getMultiBlockOrigin", "()Lnet/minecraft/util/math/BlockPos;", "positionsOfAir", "", "getPositionsOfAir", "()Ljava/util/Set;", "positionsOfSolids", "getPositionsOfSolids", "isSolidPart", "", "position", "isSupposedToBeEmpty", "divinefavor"})
public class MultiBlockInstance {
    @NotNull
    private final CuboidBoundingBox boundingBox;
    @NotNull
    private final BlockPos multiBlockOrigin;
    @NotNull
    private final Set<BlockPos> positionsOfSolids;
    @NotNull
    private final Set<BlockPos> positionsOfAir;
    @NotNull
    private final ModMultiBlock multiBlock;
    @NotNull
    private final MultiBlockConfiguration configuration;

    @NotNull
    public final CuboidBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @NotNull
    public final BlockPos getMultiBlockOrigin() {
        return this.multiBlockOrigin;
    }

    @NotNull
    public final Set<BlockPos> getPositionsOfSolids() {
        return this.positionsOfSolids;
    }

    @NotNull
    public final Set<BlockPos> getPositionsOfAir() {
        return this.positionsOfAir;
    }

    public final boolean isSolidPart(@NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.boundingBox.isCoordinateInside(position) && this.positionsOfSolids.contains(position);
    }

    public final boolean isSupposedToBeEmpty(@NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.boundingBox.isCoordinateInside(position) && this.positionsOfAir.contains(position);
    }

    @NotNull
    public final ModMultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    @NotNull
    public final MultiBlockConfiguration getConfiguration() {
        return this.configuration;
    }

    public MultiBlockInstance(@NotNull ModMultiBlock multiBlock, @NotNull MultiBlockConfiguration configuration, @NotNull BlockPos controllerPosition) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)multiBlock), (String)"multiBlock");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)controllerPosition, (String)"controllerPosition");
        this.multiBlock = multiBlock;
        this.configuration = configuration;
        CuboidBoundingBox bounds = this.configuration.getBoundingBoxRelative();
        this.boundingBox = bounds.add(controllerPosition);
        BlockPos blockPos2 = controllerPosition.func_177973_b((Vec3i)this.configuration.getControllerRelPosition());
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"controllerPosition.subtr\u2026on.controllerRelPosition)");
        this.multiBlockOrigin = blockPos2;
        HashSet air = new HashSet();
        HashSet solids = new HashSet();
        for (MultiBlockPart part : this.configuration.getParts()) {
            Sequence posList2 = SequencesKt.map(IterableExtensionsKt.getS((Iterable)part.getPositions()), (Function1)((Function1)new Function1<Vec3i, BlockPos>(this.multiBlockOrigin){

                public final BlockPos invoke(Vec3i p1) {
                    return ((BlockPos)this.receiver).func_177971_a(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(BlockPos.class);
                }

                public final String getName() {
                    return "add";
                }

                public final String getSignature() {
                    return "add(Lnet/minecraft/util/math/Vec3i;)Lnet/minecraft/util/math/BlockPos;";
                }
            }));
            if (part.getValidator() instanceof AirStateValidator) {
                CollectionsKt.addAll((Collection)air, (Sequence)posList2);
                continue;
            }
            CollectionsKt.addAll((Collection)solids, (Sequence)posList2);
        }
        Set set = Collections.unmodifiableSet(air);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(air)");
        this.positionsOfAir = set;
        Set set2 = Collections.unmodifiableSet(solids);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"Collections.unmodifiableSet(solids)");
        this.positionsOfSolids = set2;
    }
}

