/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.muliblock.serialization;

import aurocosh.divinefavor.common.muliblock.validators.AirStateValidator;
import aurocosh.divinefavor.common.muliblock.validators.BlockStateValidator;
import aurocosh.divinefavor.common.muliblock.validators.MultiBlockStateValidator;
import aurocosh.divinefavor.common.muliblock.validators.StateValidator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Laurocosh/divinefavor/common/muliblock/serialization/StateValidatorSerializer;", "Lcom/google/gson/JsonDeserializer;", "Laurocosh/divinefavor/common/muliblock/validators/StateValidator;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "divinefavor"})
public final class StateValidatorSerializer
implements JsonDeserializer<StateValidator>,
JsonSerializer<StateValidator> {
    @Nullable
    public StateValidator deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        String type;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement jsonElement = jsonObject.get("type");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"jsonObject.get(\"type\")");
        String string = type = jsonElement.getAsString();
        if (string != null) {
            switch (string) {
                case "block": {
                    JsonElement jsonElement2 = jsonObject.get("name");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"jsonObject.get(\"name\")");
                    String blockName = jsonElement2.getAsString();
                    return new BlockStateValidator(new ResourceLocation(blockName));
                }
                case "blocks": {
                    ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
                    JsonArray blocks = jsonObject.getAsJsonArray("names");
                    for (JsonElement block : blocks) {
                        names.add(new ResourceLocation(block.toString()));
                    }
                    return new MultiBlockStateValidator((List<? extends ResourceLocation>)names);
                }
                case "air": {
                    return new AirStateValidator();
                }
            }
        }
        return null;
    }

    @NotNull
    public JsonElement serialize(@NotNull StateValidator src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject json = new JsonObject();
        StateValidator stateValidator = src;
        if (stateValidator instanceof BlockStateValidator) {
            json.addProperty("type", "block");
            json.addProperty("name", ((BlockStateValidator)src).getName().toString());
        } else if (stateValidator instanceof MultiBlockStateValidator) {
            json.addProperty("type", "blocks");
            JsonArray blocks = new JsonArray();
            for (ResourceLocation name : ((MultiBlockStateValidator)src).getNames()) {
                blocks.add(name.toString());
            }
            json.add("names", (JsonElement)blocks);
        } else if (stateValidator instanceof AirStateValidator) {
            json.addProperty("type", "air");
        }
        return (JsonElement)json;
    }
}

