/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.network;

import aurocosh.divinefavor.common.block_templates.BlockTemplate;
import aurocosh.divinefavor.common.block_templates.BlockTemplateSerializer;
import aurocosh.divinefavor.common.network.TemplatePart;
import aurocosh.divinefavor.common.network.TemplatePartAssembler;
import aurocosh.divinefavor.common.util.UtilSerialize;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B4\u0012-\u0010\u0002\u001a)\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R8\u0010\u0002\u001a)\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Laurocosh/divinefavor/common/network/TemplateNetworkHandler;", "", "sender", "Lkotlin/Function3;", "Lnet/minecraft/entity/player/EntityPlayer;", "Lkotlin/ParameterName;", "name", "player", "Ljava/util/UUID;", "Laurocosh/divinefavor/common/network/TemplatePart;", "", "(Lkotlin/jvm/functions/Function3;)V", "maxPayloadSize", "", "getSender", "()Lkotlin/jvm/functions/Function3;", "templateAssemblers", "Ljava/util/HashMap;", "Laurocosh/divinefavor/common/network/TemplatePartAssembler;", "Lkotlin/collections/HashMap;", "receive", "Laurocosh/divinefavor/common/block_templates/BlockTemplate;", "uuid", "templatePart", "send", "blockTemplate", "divinefavor"})
public final class TemplateNetworkHandler {
    private final int maxPayloadSize = 32567;
    private final HashMap<UUID, TemplatePartAssembler> templateAssemblers;
    @NotNull
    private final Function3<EntityPlayer, UUID, TemplatePart, Unit> sender;

    /*
     * WARNING - void declaration
     */
    public final void send(@NotNull EntityPlayer player, @NotNull BlockTemplate blockTemplate) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)blockTemplate, (String)"blockTemplate");
        NBTTagCompound compound = BlockTemplateSerializer.INSTANCE.serialize(blockTemplate);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)outputStream);
        byte[] byteArray = outputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteArray, (String)"byteArray");
        List<byte[]> splitArray = UtilSerialize.INSTANCE.splitArray(byteArray, this.maxPayloadSize);
        boolean bl = false;
        for (byte[] value : (Iterable)splitArray) {
            void index2;
            TemplatePart templatePart = new TemplatePart((int)index2, splitArray.size(), value);
            this.sender.invoke((Object)player, (Object)blockTemplate.getUuid(), (Object)templatePart);
            ++index2;
        }
    }

    @Nullable
    public final BlockTemplate receive(@NotNull UUID uuid, @NotNull TemplatePart templatePart) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)templatePart, (String)"templatePart");
        TemplatePartAssembler templatePartAssembler = this.templateAssemblers.computeIfAbsent(uuid, new Function<UUID, TemplatePartAssembler>(templatePart){
            final /* synthetic */ TemplatePart $templatePart;

            @NotNull
            public final TemplatePartAssembler apply(@NotNull UUID it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new TemplatePartAssembler(this.$templatePart.getPartCount());
            }
            {
                this.$templatePart = templatePart;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)templatePartAssembler, (String)"templateAssemblers.compu\u2026templatePart.partCount) }");
        TemplatePartAssembler partAssembler2 = templatePartAssembler;
        partAssembler2.addPart(templatePart);
        BlockTemplate blockTemplate = partAssembler2.assemble();
        if (blockTemplate == null) {
            return null;
        }
        BlockTemplate blockTemplate2 = blockTemplate;
        this.templateAssemblers.remove(uuid);
        return blockTemplate2;
    }

    @NotNull
    public final Function3<EntityPlayer, UUID, TemplatePart, Unit> getSender() {
        return this.sender;
    }

    public TemplateNetworkHandler(@NotNull Function3<? super EntityPlayer, ? super UUID, ? super TemplatePart, Unit> sender) {
        Intrinsics.checkParameterIsNotNull(sender, (String)"sender");
        this.sender = sender;
        this.maxPayloadSize = 32567;
        this.templateAssemblers = new HashMap();
    }
}

