/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.network;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.block_templates.BlockTemplate;
import aurocosh.divinefavor.common.block_templates.BlockTemplateSerializer;
import aurocosh.divinefavor.common.network.TemplatePart;
import aurocosh.divinefavor.common.util.UtilSerialize;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\rj\b\u0012\u0004\u0012\u00020\u0003`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laurocosh/divinefavor/common/network/TemplatePartAssembler;", "", "partCount", "", "(I)V", "isComplete", "", "()Z", "parts", "Ljava/util/ArrayList;", "Laurocosh/divinefavor/common/network/TemplatePart;", "Lkotlin/collections/ArrayList;", "receivedParts", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addPart", "", "templatePart", "assemble", "Laurocosh/divinefavor/common/block_templates/BlockTemplate;", "divinefavor"})
public final class TemplatePartAssembler {
    private final ArrayList<TemplatePart> parts;
    private final HashSet<Integer> receivedParts;
    private final int partCount;

    public final void addPart(@NotNull TemplatePart templatePart) {
        Intrinsics.checkParameterIsNotNull((Object)templatePart, (String)"templatePart");
        if (templatePart.getPartIndex() < 0) {
            DivineFavor.INSTANCE.getLogger().error("Negative part index");
            return;
        }
        if (templatePart.getPartIndex() >= this.partCount) {
            DivineFavor.INSTANCE.getLogger().error("Invalid part index");
            return;
        }
        if (this.receivedParts.contains(templatePart.getPartIndex())) {
            DivineFavor.INSTANCE.getLogger().error("Duplicate part");
            return;
        }
        this.receivedParts.add(templatePart.getPartIndex());
        this.parts.add(templatePart);
    }

    public final boolean isComplete() {
        return this.receivedParts.size() == this.partCount;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockTemplate assemble() {
        NBTTagCompound compound;
        void $receiver$iv$iv;
        Object object;
        if (!this.isComplete()) {
            return null;
        }
        List $receiver$iv = this.parts;
        if ($receiver$iv.size() > 1) {
            List list2 = $receiver$iv;
            object = new Comparator<T>(){

                public final int compare(T a, T b) {
                    T receiver = a;
                    Comparable comparable = Integer.valueOf(((TemplatePart)receiver).getPartIndex());
                    receiver = b;
                    Comparable comparable2 = comparable;
                    Integer n = ((TemplatePart)receiver).getPartIndex();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)list2, (Comparator)object);
        }
        Iterable $receiver$iv2 = this.parts;
        object = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            byte[] byArray = ((TemplatePart)receiver).getBytes();
            collection.add(byArray);
        }
        List arrayParts = (List)destination$iv$iv;
        byte[] completeArray = UtilSerialize.INSTANCE.joinByteArrays(arrayParts);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(completeArray);
        NBTTagCompound nBTTagCompound = compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"compound");
        BlockTemplate blockTemplate = BlockTemplateSerializer.INSTANCE.deserialize(nBTTagCompound);
        return blockTemplate;
    }

    public TemplatePartAssembler(int partCount) {
        this.partCount = partCount;
        this.parts = new ArrayList(this.partCount);
        this.receivedParts = new HashSet(this.partCount);
    }
}

