/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.network.message.client.spirit_data;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.network.message.base.DivineClientMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Laurocosh/divinefavor/common/network/message/client/spirit_data/MessageSyncAllSpiritData;", "Laurocosh/divinefavor/common/network/message/base/DivineClientMessage;", "()V", "data", "Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritData;", "(Laurocosh/divinefavor/common/custom_data/player/data/favor/SpiritData;)V", "contracts", "Lnet/minecraft/nbt/NBTTagCompound;", "getContracts", "()Lnet/minecraft/nbt/NBTTagCompound;", "setContracts", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "favorInfinite", "", "getFavorInfinite", "()[Z", "setFavorInfinite", "([Z)V", "favorValues", "", "getFavorValues", "()[I", "setFavorValues", "([I)V", "handleSafe", "", "divinefavor"})
public final class MessageSyncAllSpiritData
extends DivineClientMessage {
    @NotNull
    private NBTTagCompound contracts;
    @NotNull
    private int[] favorValues;
    @NotNull
    private boolean[] favorInfinite;

    @NotNull
    public final NBTTagCompound getContracts() {
        return this.contracts;
    }

    public final void setContracts(@NotNull NBTTagCompound nBTTagCompound) {
        Intrinsics.checkParameterIsNotNull((Object)nBTTagCompound, (String)"<set-?>");
        this.contracts = nBTTagCompound;
    }

    @NotNull
    public final int[] getFavorValues() {
        return this.favorValues;
    }

    public final void setFavorValues(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.favorValues = nArray;
    }

    @NotNull
    public final boolean[] getFavorInfinite() {
        return this.favorInfinite;
    }

    public final void setFavorInfinite(@NotNull boolean[] blArray) {
        Intrinsics.checkParameterIsNotNull((Object)blArray, (String)"<set-?>");
        this.favorInfinite = blArray;
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleSafe() {
        EntityPlayer player = DivineFavor.INSTANCE.getProxy().getClientPlayer();
        SpiritData data = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        data.deserializeContracts(this.contracts);
        data.setFavorValues(this.favorValues);
        data.setFavorInfinite(this.favorInfinite);
    }

    public MessageSyncAllSpiritData() {
        this.contracts = new NBTTagCompound();
        this.favorValues = new int[0];
        this.favorInfinite = new boolean[0];
    }

    public MessageSyncAllSpiritData(@NotNull SpiritData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.contracts = new NBTTagCompound();
        this.favorValues = new int[0];
        this.favorInfinite = new boolean[0];
        this.contracts = data.serializeContracts();
        this.favorValues = data.getFavorValues();
        this.favorInfinite = data.getFavorInfinite();
    }
}

