/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.potions.base.potion;

import aurocosh.divinefavor.common.core.ResourceNamer;
import aurocosh.divinefavor.common.custom_data.living.data.curse.CurseData;
import aurocosh.divinefavor.common.lib.extensions.LivingBaseExtensionsKt;
import aurocosh.divinefavor.common.registry.ModRegistries;
import aurocosh.divinefavor.common.util.UtilGui;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J(\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J0\u0010'\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0017J(\u0010*\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Laurocosh/divinefavor/common/potions/base/potion/ModPotion;", "Lnet/minecraft/potion/Potion;", "name", "", "potionColor", "", "(Ljava/lang/String;I)V", "icon", "Lnet/minecraft/util/ResourceLocation;", "getIcon", "()Lnet/minecraft/util/ResourceLocation;", "setIcon", "(Lnet/minecraft/util/ResourceLocation;)V", "isCurse", "", "()Z", "setCurse", "(Z)V", "applyAttributesModifiersToEntity", "", "livingBase", "Lnet/minecraft/entity/EntityLivingBase;", "attributeMap", "Lnet/minecraft/entity/ai/attributes/AbstractAttributeMap;", "amplifier", "getCurativeItems", "", "Lnet/minecraft/item/ItemStack;", "onPotionAdded", "onPotionRemoved", "performEffect", "removeAttributesModifiersFromEntity", "renderCustomInvText", "x", "y", "effect", "Lnet/minecraft/potion/PotionEffect;", "mc", "Lnet/minecraft/client/Minecraft;", "renderHUDEffect", "alpha", "", "renderInventoryEffect", "setIsCurse", "curse", "divinefavor"})
public abstract class ModPotion
extends Potion {
    @NotNull
    private ResourceLocation icon;
    private boolean isCurse;

    @NotNull
    public final ResourceLocation getIcon() {
        return this.icon;
    }

    public final void setIcon(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"<set-?>");
        this.icon = resourceLocation;
    }

    protected final boolean isCurse() {
        return this.isCurse;
    }

    protected final void setCurse(boolean bl) {
        this.isCurse = bl;
    }

    public final void setIsCurse(boolean curse) {
        this.isCurse = curse;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, @NotNull PotionEffect effect, @NotNull Minecraft mc) {
        Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        UtilGui.INSTANCE.drawTexture(mc, this.icon, x + 6, y + 6, 16, 16);
        this.renderCustomInvText(x, y, effect, mc);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCustomInvText(int x, int y, @NotNull PotionEffect effect, @NotNull Minecraft mc) {
        Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, @NotNull PotionEffect effect, @NotNull Minecraft mc, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        UtilGui.INSTANCE.drawTexture(mc, this.icon, x + 4, y + 4, 16, 16);
    }

    public void func_76394_a(@NotNull EntityLivingBase livingBase, int amplifier) {
        Intrinsics.checkParameterIsNotNull((Object)livingBase, (String)"livingBase");
    }

    @NotNull
    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Items.field_151117_aB));
        return ret;
    }

    public void func_111185_a(@NotNull EntityLivingBase livingBase, @NotNull AbstractAttributeMap attributeMap, int amplifier) {
        Intrinsics.checkParameterIsNotNull((Object)livingBase, (String)"livingBase");
        Intrinsics.checkParameterIsNotNull((Object)attributeMap, (String)"attributeMap");
        super.func_111185_a(livingBase, attributeMap, amplifier);
        this.onPotionAdded(livingBase);
    }

    public void func_111187_a(@NotNull EntityLivingBase livingBase, @NotNull AbstractAttributeMap attributeMap, int amplifier) {
        Intrinsics.checkParameterIsNotNull((Object)livingBase, (String)"livingBase");
        Intrinsics.checkParameterIsNotNull((Object)attributeMap, (String)"attributeMap");
        super.func_111187_a(livingBase, attributeMap, amplifier);
        this.onPotionRemoved(livingBase);
    }

    protected void onPotionAdded(@NotNull EntityLivingBase livingBase) {
        Intrinsics.checkParameterIsNotNull((Object)livingBase, (String)"livingBase");
        if (this.isCurse) {
            CurseData curse = LivingBaseExtensionsKt.getDivineLivingData(livingBase).getCurseData();
            curse.addCurse();
        }
    }

    protected void onPotionRemoved(@NotNull EntityLivingBase livingBase) {
        Intrinsics.checkParameterIsNotNull((Object)livingBase, (String)"livingBase");
        if (this.isCurse) {
            CurseData curse = LivingBaseExtensionsKt.getDivineLivingData(livingBase).getCurseData();
            curse.removeCurse();
        }
    }

    public ModPotion(@NotNull String name, int potionColor) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(false, potionColor);
        this.isCurse = false;
        this.icon = new ResourceLocation("divinefavor", "textures/potions/" + name + ".png");
        ResourceLocation fullName = ResourceNamer.INSTANCE.getFullName(name);
        this.func_76390_b("potion." + fullName + ".name");
        this.setRegistryName(fullName);
        ModRegistries.INSTANCE.getPotions().register((IForgeRegistryEntry)this);
    }
}

