/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.spirit.base;

import aurocosh.divinefavor.DivineFavor;
import aurocosh.divinefavor.common.config.entries.SpiritConfig;
import aurocosh.divinefavor.common.core.ResourceNamer;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.global.dayClock.DayClock;
import aurocosh.divinefavor.common.lib.TimePeriod;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.lib.interfaces.IIndexedEntry;
import aurocosh.divinefavor.common.network.message.client.activity.MessageSpiritBecameActive;
import aurocosh.divinefavor.common.network.message.client.activity.MessageSpiritBecameInactive;
import aurocosh.divinefavor.common.network.message.client.spirit_data.MessageSyncFavor;
import aurocosh.divinefavor.common.registry.ModRegistries;
import aurocosh.divinefavor.common.registry.mappers.ModMappers;
import aurocosh.divinefavor.common.spirit.base.SpiritPunishment;
import aurocosh.divinefavor.common.util.UtilDayTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\u0016\u00100\u001a\u00020.2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u0016\u00104\u001a\u00020.2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u0016\u00105\u001a\u00020.2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\b\u00106\u001a\u00020.H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019\u00a8\u00067"}, d2={"Laurocosh/divinefavor/common/spirit/base/ModSpirit;", "Lnet/minecraftforge/registries/IForgeRegistryEntry$Impl;", "Laurocosh/divinefavor/common/lib/interfaces/IIndexedEntry;", "name", "", "punishment", "Laurocosh/divinefavor/common/spirit/base/SpiritPunishment;", "config", "Laurocosh/divinefavor/common/config/entries/SpiritConfig;", "(Ljava/lang/String;Laurocosh/divinefavor/common/spirit/base/SpiritPunishment;Laurocosh/divinefavor/common/config/entries/SpiritConfig;)V", "activityPeriod", "Laurocosh/divinefavor/common/lib/TimePeriod;", "getActivityPeriod", "()Laurocosh/divinefavor/common/lib/TimePeriod;", "favorMax", "", "getFavorMax", "()I", "favorMin", "getFavorMin", "favorRegen", "getFavorRegen", "icon", "Lnet/minecraft/util/ResourceLocation;", "getIcon", "()Lnet/minecraft/util/ResourceLocation;", "id", "getId", "isActive", "", "()Z", "getName", "()Ljava/lang/String;", "nameTranslationKey", "getNameTranslationKey", "offering", "Lnet/minecraft/item/Item;", "getOffering", "()Lnet/minecraft/item/Item;", "offeringCount", "getOfferingCount", "getPunishment", "()Laurocosh/divinefavor/common/spirit/base/SpiritPunishment;", "symbol", "getSymbol", "becameActive", "", "becameInactive", "informActivity", "playerList", "", "Lnet/minecraft/entity/player/EntityPlayerMP;", "informInactivity", "regenerateFavor", "registerActivityPeriod", "divinefavor"})
public final class ModSpirit
extends IForgeRegistryEntry.Impl<ModSpirit>
implements IIndexedEntry {
    private final int id;
    @Nullable
    private final Item offering;
    private final int offeringCount;
    @NotNull
    private final TimePeriod activityPeriod;
    @NotNull
    private final ResourceLocation icon;
    @NotNull
    private final ResourceLocation symbol;
    private final int favorMin;
    private final int favorMax;
    private final int favorRegen;
    @NotNull
    private final String name;
    @NotNull
    private final SpiritPunishment punishment;

    @Override
    public int getId() {
        return this.id;
    }

    @Nullable
    public final Item getOffering() {
        return this.offering;
    }

    public final int getOfferingCount() {
        return this.offeringCount;
    }

    @NotNull
    public final TimePeriod getActivityPeriod() {
        return this.activityPeriod;
    }

    @NotNull
    public final ResourceLocation getIcon() {
        return this.icon;
    }

    @NotNull
    public final ResourceLocation getSymbol() {
        return this.symbol;
    }

    public final int getFavorMin() {
        return this.favorMin;
    }

    public final int getFavorMax() {
        return this.favorMax;
    }

    public final int getFavorRegen() {
        return this.favorRegen;
    }

    public final boolean isActive() {
        int timeOfDay = DayClock.INSTANCE.getTimeTicks();
        return this.activityPeriod.isDayTimeInRange(timeOfDay);
    }

    @NotNull
    public final String getNameTranslationKey() {
        return String.valueOf(this.getRegistryName()) + ".name";
    }

    private final void becameActive() {
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        MinecraftServer minecraftServer = fMLCommonHandler.getMinecraftServerInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"FMLCommonHandler.instanc\u2026).minecraftServerInstance");
        PlayerList playerList = minecraftServer.func_184103_al();
        Intrinsics.checkExpressionValueIsNotNull((Object)playerList, (String)"FMLCommonHandler.instanc\u2026ServerInstance.playerList");
        List playerList2 = playerList.func_181057_v();
        if (playerList2.isEmpty()) {
            return;
        }
        if (((EntityPlayerMP)playerList2.get((int)0)).field_70170_p.field_72995_K) {
            return;
        }
        List list2 = playerList2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"playerList");
        this.regenerateFavor(list2);
        this.informActivity(playerList2);
    }

    private final void regenerateFavor(List<? extends EntityPlayerMP> playerList) {
        for (EntityPlayerMP entityPlayerMP : playerList) {
            SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData((EntityPlayer)entityPlayerMP).getSpiritData();
            if (!spiritData.regenerateFavor(this.getId())) continue;
            new MessageSyncFavor(this, spiritData).sendTo((EntityPlayer)entityPlayerMP);
        }
    }

    private final void informActivity(List<? extends EntityPlayerMP> playerList) {
        for (EntityPlayerMP entityPlayerMP : playerList) {
            if (!PlayerExtensionsKt.getDivinePlayerData((EntityPlayer)entityPlayerMP).getSpiritData().isInform(this.getId())) continue;
            new MessageSpiritBecameActive(this.getId()).sendTo((EntityPlayer)entityPlayerMP);
        }
    }

    private final void becameInactive() {
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        MinecraftServer minecraftServer = fMLCommonHandler.getMinecraftServerInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"FMLCommonHandler.instanc\u2026).minecraftServerInstance");
        PlayerList playerList = minecraftServer.func_184103_al();
        Intrinsics.checkExpressionValueIsNotNull((Object)playerList, (String)"FMLCommonHandler.instanc\u2026ServerInstance.playerList");
        List playerList2 = playerList.func_181057_v();
        if (playerList2.isEmpty()) {
            return;
        }
        if (((EntityPlayerMP)playerList2.get((int)0)).field_70170_p.field_72995_K) {
            return;
        }
        List list2 = playerList2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"playerList");
        this.informInactivity(list2);
    }

    private final void informInactivity(List<? extends EntityPlayerMP> playerList) {
        for (EntityPlayerMP entityPlayerMP : playerList) {
            if (!PlayerExtensionsKt.getDivinePlayerData((EntityPlayer)entityPlayerMP).getSpiritData().isInform(this.getId())) continue;
            new MessageSpiritBecameInactive(this.getId()).sendTo((EntityPlayer)entityPlayerMP);
        }
    }

    private final void registerActivityPeriod() {
        DayClock.INSTANCE.addAlarm(this.activityPeriod.getStart(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ModSpirit this$0;

            public final void invoke() {
                ModSpirit.access$becameActive(this.this$0);
            }
            {
                this.this$0 = modSpirit;
                super(0);
            }
        }), true);
        DayClock.INSTANCE.addAlarm(this.activityPeriod.getStop(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ModSpirit this$0;

            public final void invoke() {
                ModSpirit.access$becameInactive(this.this$0);
            }
            {
                this.this$0 = modSpirit;
                super(0);
            }
        }), true);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final SpiritPunishment getPunishment() {
        return this.punishment;
    }

    public ModSpirit(@NotNull String name, @NotNull SpiritPunishment punishment, @NotNull SpiritConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)punishment, (String)"punishment");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.name = name;
        this.punishment = punishment;
        this.offering = Item.func_111206_d((String)config.offering);
        if (this.offering == null) {
            DivineFavor.INSTANCE.getLogger().error("Spirit error: " + this.name + ". Offering not found: " + config.offering);
        }
        this.offeringCount = config.offeringCount;
        this.activityPeriod = UtilDayTime.INSTANCE.fromHours(config.activityPeriod.start, config.activityPeriod.stop);
        this.favorMin = config.startingPlayerFavorMinimum;
        this.favorMax = config.startingPlayerFavorMaximum;
        this.favorRegen = config.startingPlayerFavorRegen;
        this.setRegistryName(ResourceNamer.INSTANCE.getFullName("spirit", this.name));
        this.icon = new ResourceLocation("divinefavor:textures/items/calling_stones/" + this.name + ".png");
        this.symbol = new ResourceLocation("divinefavor:textures/items/symbols/" + this.name + ".png");
        this.id = ModMappers.INSTANCE.getSpirits().register((ModSpirit)((IForgeRegistryEntry)this));
        ModRegistries.INSTANCE.getSpirits().register((IForgeRegistryEntry)this);
        this.registerActivityPeriod();
    }

    public static final /* synthetic */ void access$becameActive(ModSpirit $this) {
        $this.becameActive();
    }

    public static final /* synthetic */ void access$becameInactive(ModSpirit $this) {
        $this.becameInactive();
    }
}

