/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.spirit.punishment;

import aurocosh.divinefavor.common.config.common.ConfigPunishments;
import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.lib.extensions.WorldExtensionsKt;
import aurocosh.divinefavor.common.muliblock.instance.MultiBlockInstance;
import aurocosh.divinefavor.common.spirit.base.SpiritPunishment;
import aurocosh.divinefavor.common.util.UtilBlock;
import aurocosh.divinefavor.common.util.UtilCoordinates;
import aurocosh.divinefavor.common.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Laurocosh/divinefavor/common/spirit/punishment/EnderererPunishment;", "Laurocosh/divinefavor/common/spirit/base/SpiritPunishment;", "()V", "execute", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "instance", "Laurocosh/divinefavor/common/muliblock/instance/MultiBlockInstance;", "swapBlocks", "position", "teleportPartsOfAltar", "divinefavor"})
public final class EnderererPunishment
extends SpiritPunishment {
    @Override
    public void execute(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull IBlockState state2, @NotNull MultiBlockInstance instance) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        int radius = ConfigPunishments.endererer.playerTeleportRadius;
        BlockPos destination = UtilCoordinates.INSTANCE.getRandomNeighbourSafe(pos2, radius, radius, radius);
        UtilEntity.INSTANCE.teleport((EntityLivingBase)player, destination);
        this.teleportPartsOfAltar(player, world, instance);
    }

    /*
     * WARNING - void declaration
     */
    private final void teleportPartsOfAltar(EntityPlayer player, World world, MultiBlockInstance instance) {
        void $receiver$iv$iv;
        void $receiver$iv;
        int blocksToMove = ConfigPunishments.endererer.blocksToMove.random();
        ArrayList solidsPositions = new ArrayList(instance.getPositionsOfSolids());
        Iterable iterable = solidsPositions;
        World world2 = world;
        Object object = Blocks.field_150402_ci;
        void var10_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BlockPos p1 = (BlockPos)element$iv$iv;
            if (!object.equals((Object)(p1 = WorldExtensionsKt.getBlock(world2, p1)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List coalPositions = (List)destination$iv$iv;
        List selectedPositions = IterableExtensionsKt.selectRandom(coalPositions, blocksToMove);
        object = selectedPositions.iterator();
        while (object.hasNext()) {
            BlockPos position;
            BlockPos blockPos2 = position = (BlockPos)object.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"position");
            this.swapBlocks(player, world, blockPos2);
        }
    }

    private final void swapBlocks(EntityPlayer player, World world, BlockPos position) {
        IBlockState destinationState;
        if (!world.func_175623_d(position) && !UtilBlock.INSTANCE.canBreakBlock(player, world, position, false)) {
            return;
        }
        int blockTeleportRadius = ConfigPunishments.endererer.blockTeleportRadius;
        BlockPos destination = UtilCoordinates.INSTANCE.getRandomNeighbourSafe(position, blockTeleportRadius, blockTeleportRadius, blockTeleportRadius);
        if (!WorldExtensionsKt.isAirOrReplacable(world, destination) && !UtilBlock.INSTANCE.canBreakBlock(player, world, destination, false)) {
            return;
        }
        IBlockState positionState = world.func_180495_p(position);
        IBlockState iBlockState = destinationState = world.func_180495_p(destination);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"destinationState");
        UtilBlock.INSTANCE.replaceBlock(player, world, position, iBlockState);
        IBlockState iBlockState2 = positionState;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"positionState");
        UtilBlock.INSTANCE.replaceBlock(player, world, destination, iBlockState2);
    }
}

