/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.spirit.punishment;

import aurocosh.divinefavor.common.config.common.ConfigPunishments;
import aurocosh.divinefavor.common.lib.distributed_random.DistributedRandomEntityList;
import aurocosh.divinefavor.common.muliblock.instance.MultiBlockInstance;
import aurocosh.divinefavor.common.spirit.base.SpiritPunishment;
import aurocosh.divinefavor.common.tasks.base.ServerSideTask;
import aurocosh.divinefavor.common.util.UtilAlgorithm;
import aurocosh.divinefavor.common.util.UtilCoordinates;
import aurocosh.divinefavor.common.util.UtilEntity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Laurocosh/divinefavor/common/spirit/punishment/LoonPunishment;", "Laurocosh/divinefavor/common/spirit/base/SpiritPunishment;", "()V", "execute", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "instance", "Laurocosh/divinefavor/common/muliblock/instance/MultiBlockInstance;", "LoonPunishmentTask", "divinefavor"})
public final class LoonPunishment
extends SpiritPunishment {
    @Override
    public void execute(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull IBlockState state2, @NotNull MultiBlockInstance instance) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        LoonPunishmentTask task2 = new LoonPunishmentTask(player);
        task2.start();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/common/spirit/punishment/LoonPunishment$LoonPunishmentTask;", "Laurocosh/divinefavor/common/tasks/base/ServerSideTask;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "waveCount", "", "waveDelay", "onPlayerLogout", "", "event", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerLoggedOutEvent;", "spawnMob", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "tickEvent", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "Companion", "divinefavor"})
    public static final class LoonPunishmentTask
    extends ServerSideTask {
        private int waveCount;
        private int waveDelay;
        private final EntityPlayer player;
        private static final DistributedRandomEntityList possibleEnemies;
        public static final Companion Companion;

        @SubscribeEvent
        public final void tickEvent(@NotNull TickEvent.WorldTickEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            World world = event.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
            if (!this.isSameDimension(world)) {
                return;
            }
            int n = this.waveDelay;
            this.waveDelay = n + -1;
            if (n > 0) {
                return;
            }
            this.waveDelay = ConfigPunishments.loon.waveDelay.random();
            int mobsToSpawn = ConfigPunishments.loon.enemiesPerWave.random();
            int spawnAttempts = mobsToSpawn * 10;
            BlockPos playerPosition = this.player.func_180425_c();
            UtilAlgorithm.INSTANCE.repeatUntilSuccessful((Function0<Boolean>)((Function0)new Function0<Boolean>(this, playerPosition){
                final /* synthetic */ LoonPunishmentTask this$0;
                final /* synthetic */ BlockPos $playerPosition;

                public final boolean invoke() {
                    World world = LoonPunishmentTask.access$getWorld$p(this.this$0);
                    BlockPos blockPos2 = this.$playerPosition;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"playerPosition");
                    return LoonPunishmentTask.access$spawnMob(this.this$0, world, blockPos2);
                }
                {
                    this.this$0 = loonPunishmentTask;
                    this.$playerPosition = blockPos2;
                    super(0);
                }
            }), mobsToSpawn, spawnAttempts);
            int n2 = this.waveCount;
            this.waveCount = n2 + -1;
            if (n2 <= 0) {
                this.finish();
            }
        }

        @SubscribeEvent
        public final void onPlayerLogout(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.player == this.player) {
                this.finish();
            }
        }

        private final boolean spawnMob(World world, BlockPos pos2) {
            int spawnRadius = ConfigPunishments.loon.spawnRadius;
            BlockPos randomPos = UtilCoordinates.INSTANCE.getRandomNeighbour(pos2, spawnRadius, 0, spawnRadius);
            BlockPos spawnPos = UtilCoordinates.INSTANCE.findPlaceToStand(randomPos, world, spawnRadius);
            if (spawnPos != null && possibleEnemies.size() > 0) {
                Class clazz = (Class)possibleEnemies.getRandom();
                if (clazz == null) {
                    return false;
                }
                Class clazz2 = clazz;
                return UtilEntity.INSTANCE.spawnEntity(world, spawnPos, clazz2);
            }
            return false;
        }

        public LoonPunishmentTask(@NotNull EntityPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            World world = player.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
            super(world);
            this.player = player;
            this.waveCount = ConfigPunishments.loon.waveCount.random();
            this.waveDelay = 0;
        }

        static {
            Companion = new Companion(null);
            Map<String, Double> map2 = ConfigPunishments.loon.summonedEnemies;
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"ConfigPunishments.loon.summonedEnemies");
            possibleEnemies = new DistributedRandomEntityList(map2);
        }

        public static final /* synthetic */ boolean access$spawnMob(LoonPunishmentTask $this, @NotNull World world, @NotNull BlockPos pos2) {
            return $this.spawnMob(world, pos2);
        }

        @NotNull
        public static final /* synthetic */ World access$getWorld$p(LoonPunishmentTask $this) {
            return $this.getWorld();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Laurocosh/divinefavor/common/spirit/punishment/LoonPunishment$LoonPunishmentTask$Companion;", "", "()V", "possibleEnemies", "Laurocosh/divinefavor/common/lib/distributed_random/DistributedRandomEntityList;", "divinefavor"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

