/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.stack_properties.properties.base;

import aurocosh.divinefavor.common.core.ResourceNamer;
import aurocosh.divinefavor.common.lib.extensions.ItemStackExtensionsKt;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010#\u001a\u00020\u00072\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000eJ,\u0010%\u001a\u00020\u00072$\u0010$\u001a \u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u001eJ \u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\b\b\u0002\u0010)\u001a\u00020\u0007J\u0013\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\u000f\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00020/H&\u00a2\u0006\u0002\u00100J%\u00101\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u000f2\u0006\u00102\u001a\u00028\u00002\b\b\u0002\u0010)\u001a\u00020\u0007\u00a2\u0006\u0002\u00103J\u001d\u00104\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u000fH'R&\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR2\u0010\u001d\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u001e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016\u00a8\u00067"}, d2={"Laurocosh/divinefavor/common/stack_properties/properties/base/StackProperty;", "T", "", "name", "", "defaultValue", "showInTooltip", "", "showInGui", "orderIndex", "", "(Ljava/lang/String;Ljava/lang/Object;ZZI)V", "changeListeners", "", "Lkotlin/Function2;", "Lnet/minecraft/item/ItemStack;", "", "getDefaultValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "displayKey", "getDisplayKey", "()Ljava/lang/String;", "getName", "getOrderIndex", "()I", "getShowInGui", "()Z", "getShowInTooltip", "syncListeners", "Lkotlin/Function3;", "tag", "getTag", "tooltipKey", "getTooltipKey", "addChangeListener", "listener", "addSyncListener", "copy", "fromStack", "toStack", "sync", "getValue", "stack", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/Object;", "getValueFromTag", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "(Lnet/minecraft/nbt/NBTTagCompound;)Ljava/lang/Object;", "setValue", "value", "(Lnet/minecraft/item/ItemStack;Ljava/lang/Object;Z)Z", "setValueToTag", "(Lnet/minecraft/nbt/NBTTagCompound;Ljava/lang/Object;)V", "toLocalString", "divinefavor"})
public abstract class StackProperty<T> {
    @NotNull
    private final String tag;
    @NotNull
    private final String tooltipKey;
    @NotNull
    private final String displayKey;
    private final Set<Function2<ItemStack, T, Unit>> changeListeners;
    private final Set<Function3<Integer, StackProperty<T>, T, Unit>> syncListeners;
    @NotNull
    private final String name;
    @NotNull
    private final T defaultValue;
    private final boolean showInTooltip;
    private final boolean showInGui;
    private final int orderIndex;

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final String getTooltipKey() {
        return this.tooltipKey;
    }

    @NotNull
    public final String getDisplayKey() {
        return this.displayKey;
    }

    public final boolean addChangeListener(@NotNull Function2<? super ItemStack, ? super T, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        return this.changeListeners.add(listener);
    }

    public final boolean addSyncListener(@NotNull Function3<? super Integer, ? super StackProperty<T>, ? super T, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        return this.syncListeners.add(listener);
    }

    @NotNull
    public final T getValue(@NotNull ItemStack stack2) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        if (!ItemStackExtensionsKt.checkForTag(stack2, this.tag)) {
            return this.defaultValue;
        }
        NBTTagCompound nBTTagCompound = stack2.func_77978_p();
        if (nBTTagCompound == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        }
        NBTTagCompound compound = nBTTagCompound;
        return this.getValueFromTag(compound);
    }

    public final boolean setValue(@NotNull ItemStack stack2, @NotNull T value, boolean sync) {
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        T current = this.getValue(stack2);
        if (Intrinsics.areEqual(current, value)) {
            return false;
        }
        this.setValueToTag(ItemStackExtensionsKt.getCompound(stack2), value);
        Iterable $receiver$iv = this.changeListeners;
        for (Object element$iv : $receiver$iv) {
            Function2 it = (Function2)element$iv;
            it.invoke((Object)stack2, value);
        }
        if (sync) {
            int itemId = Item.func_150891_b((Item)stack2.func_77973_b());
            Iterable $receiver$iv2 = this.syncListeners;
            for (Object element$iv : $receiver$iv2) {
                Function3 it = (Function3)element$iv;
                it.invoke((Object)itemId, (Object)this, value);
            }
        }
        return true;
    }

    public static /* synthetic */ boolean setValue$default(StackProperty stackProperty, ItemStack itemStack, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setValue");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return stackProperty.setValue(itemStack, object, bl);
    }

    public final void copy(@NotNull ItemStack fromStack, @NotNull ItemStack toStack, boolean sync) {
        Intrinsics.checkParameterIsNotNull((Object)fromStack, (String)"fromStack");
        Intrinsics.checkParameterIsNotNull((Object)toStack, (String)"toStack");
        if (ItemStackExtensionsKt.isPropertySet(fromStack, this)) {
            this.setValue(toStack, this.getValue(fromStack), sync);
        }
    }

    public static /* synthetic */ void copy$default(StackProperty stackProperty, ItemStack itemStack, ItemStack itemStack2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        stackProperty.copy(itemStack, itemStack2, bl);
    }

    @NotNull
    public abstract T getValueFromTag(@NotNull NBTTagCompound var1);

    public abstract void setValueToTag(@NotNull NBTTagCompound var1, @NotNull T var2);

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public abstract String toLocalString(@NotNull ItemStack var1);

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean getShowInTooltip() {
        return this.showInTooltip;
    }

    public final boolean getShowInGui() {
        return this.showInGui;
    }

    public final int getOrderIndex() {
        return this.orderIndex;
    }

    public StackProperty(@NotNull String name, @NotNull T defaultValue, boolean showInTooltip, boolean showInGui, int orderIndex) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        this.name = name;
        this.defaultValue = defaultValue;
        this.showInTooltip = showInTooltip;
        this.showInGui = showInGui;
        this.orderIndex = orderIndex;
        this.tag = "tag_" + this.name;
        this.tooltipKey = ResourceNamer.INSTANCE.getTypedNameString("tooltip", "property", this.name);
        this.displayKey = ResourceNamer.INSTANCE.getTypedNameString("name", "property", this.name);
        this.changeListeners = new HashSet();
        this.syncListeners = new HashSet();
    }
}

