/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.tasks;

import aurocosh.divinefavor.common.tasks.base.ServerSideTask;
import aurocosh.divinefavor.common.util.UtilBlock;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laurocosh/divinefavor/common/tasks/BlockBreakingTask;", "Laurocosh/divinefavor/common/tasks/base/ServerSideTask;", "blocksToRemove", "", "Lnet/minecraft/util/math/BlockPos;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "tool", "Lnet/minecraft/item/ItemStack;", "blocksPerTick", "", "(Ljava/util/List;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;I)V", "Ljava/util/Queue;", "blockBreak", "", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "divinefavor"})
public final class BlockBreakingTask
extends ServerSideTask {
    private final Queue<BlockPos> blocksToRemove;
    private final EntityPlayer player;
    private final ItemStack tool;
    private final int blocksPerTick;

    @SubscribeEvent
    public final void blockBreak(@NotNull TickEvent.WorldTickEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        World world = event.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
        if (!this.isSameDimension(world)) {
            return;
        }
        int n = this.blocksPerTick;
        int n2 = this.blocksToRemove.size();
        int breakCount = Math.min(n, n2);
        while (breakCount-- > 0) {
            World world2 = this.getWorld();
            BlockPos blockPos2 = this.blocksToRemove.remove();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"blocksToRemove.remove()");
            UtilBlock.INSTANCE.removeBlock(this.player, world2, this.tool, blockPos2, true, false, false);
        }
        if (this.blocksToRemove.isEmpty()) {
            this.finish();
        }
    }

    public BlockBreakingTask(@NotNull List<? extends BlockPos> blocksToRemove, @NotNull EntityPlayer player, @NotNull ItemStack tool, int blocksPerTick) {
        Intrinsics.checkParameterIsNotNull(blocksToRemove, (String)"blocksToRemove");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
        World world = player.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
        super(world);
        this.player = player;
        this.tool = tool;
        this.blocksPerTick = blocksPerTick;
        this.blocksToRemove = new LinkedList(blocksToRemove);
    }
}

