/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.tasks;

import aurocosh.divinefavor.common.tasks.base.ServerSideTask;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laurocosh/divinefavor/common/tasks/BlockProcessingTask;", "Laurocosh/divinefavor/common/tasks/base/ServerSideTask;", "blocks", "", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/World;", "blocksPerTick", "", "processor", "Lkotlin/Function1;", "", "(Ljava/util/List;Lnet/minecraft/world/World;ILkotlin/jvm/functions/Function1;)V", "Ljava/util/Queue;", "blockBreak", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "divinefavor"})
public final class BlockProcessingTask
extends ServerSideTask {
    private final Queue<BlockPos> blocks;
    private final int blocksPerTick;
    private final Function1<BlockPos, Unit> processor;

    @SubscribeEvent
    public final void blockBreak(@NotNull TickEvent.WorldTickEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        World world = event.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
        if (!this.isSameDimension(world)) {
            return;
        }
        int breakCount = Math.min(this.blocksPerTick, this.blocks.size());
        while (breakCount-- > 0) {
            BlockPos blockPos2 = this.blocks.remove();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"blocks.remove()");
            this.processor.invoke((Object)blockPos2);
        }
        if (this.blocks.isEmpty()) {
            this.finish();
        }
    }

    public BlockProcessingTask(@NotNull List<? extends BlockPos> blocks, @NotNull World world, int blocksPerTick, @NotNull Function1<? super BlockPos, Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        super(world);
        this.blocksPerTick = blocksPerTick;
        this.processor = processor2;
        this.blocks = new LinkedList(blocks);
    }
}

