/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.tasks;

import aurocosh.divinefavor.common.tasks.base.ServerSideTask;
import aurocosh.divinefavor.common.util.UtilBlock;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laurocosh/divinefavor/common/tasks/BlockReplacingTask;", "Laurocosh/divinefavor/common/tasks/base/ServerSideTask;", "blocksToPlace", "", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "blocksPerTick", "", "(Ljava/util/List;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;I)V", "Ljava/util/Queue;", "blockPlace", "", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "divinefavor"})
public final class BlockReplacingTask
extends ServerSideTask {
    private final Queue<BlockPos> blocksToPlace;
    private final IBlockState state;
    private final EntityPlayer player;
    private final int blocksPerTick;

    @SubscribeEvent
    public final void blockPlace(@NotNull TickEvent.WorldTickEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        World world = event.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
        if (!this.isSameDimension(world)) {
            return;
        }
        int breakCount = Math.min(this.blocksPerTick, this.blocksToPlace.size());
        while (breakCount-- > 0) {
            BlockPos pos2 = this.blocksToPlace.remove();
            World world2 = this.getWorld();
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            BlockPos blockPos2 = pos2;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
            UtilBlock.INSTANCE.removeBlock(this.player, world2, itemStack, blockPos2, true, false, false);
            UtilBlock.INSTANCE.replaceBlock(this.player, this.getWorld(), pos2, this.state);
        }
        if (this.blocksToPlace.isEmpty()) {
            this.finish();
        }
    }

    public BlockReplacingTask(@NotNull List<? extends BlockPos> blocksToPlace, @NotNull IBlockState state2, @NotNull EntityPlayer player, int blocksPerTick) {
        Intrinsics.checkParameterIsNotNull(blocksToPlace, (String)"blocksToPlace");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        World world = player.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
        super(world);
        this.state = state2;
        this.player = player;
        this.blocksPerTick = blocksPerTick;
        this.blocksToPlace = new LinkedList(blocksToPlace);
    }
}

