/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import aurocosh.divinefavor.common.block.common.ModBlocks;
import aurocosh.divinefavor.common.block.doppel.TileEtherealGoo;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J>\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J.\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J&\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J&\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0010J.\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'J&\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0010J\u001e\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006*"}, d2={"Laurocosh/divinefavor/common/util/UtilBlock;", "", "()V", "canBreakBlock", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "isToolRequired", "canReplaceBlock", "destroyBlock", "", "state", "Lnet/minecraft/block/state/IBlockState;", "getSilkDropIfPresent", "Lnet/minecraft/item/ItemStack;", "getSilkTouchDrop", "harvestBlockAndReplant", "fortune", "", "ignite", "facing", "Lnet/minecraft/util/EnumFacing;", "isAirOrReplaceable", "moveBlock", "removeBlock", "tool", "dropItem", "particles", "removeBlockAndReplant", "replaceBlock", "block", "Lnet/minecraft/block/Block;", "newState", "stack", "hand", "Lnet/minecraft/util/EnumHand;", "replaceBlockWithGoo", "smeltBlock", "divinefavor"})
public final class UtilBlock {
    public static final UtilBlock INSTANCE;

    public final boolean canReplaceBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (pos2.func_177956_o() < 0) {
            return false;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        if (!world.func_175667_e(pos2)) {
            return false;
        }
        if (!world.func_175660_a(player, pos2)) {
            bl = false;
        } else {
            IBlockState iBlockState = world.func_180495_p(pos2);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
            bl = iBlockState.func_177230_c() != Blocks.field_150357_h;
        }
        return bl;
    }

    public final boolean canBreakBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, boolean isToolRequired) {
        IBlockState state2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (!this.canReplaceBlock(player, world, pos2)) {
            return false;
        }
        IBlockState iBlockState = state2 = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        Block block = iBlockState.func_177230_c();
        if (block.isAir(state2, (IBlockAccess)world, pos2) || block instanceof BlockLiquid || block instanceof IFluidBlock) {
            return false;
        }
        if (isToolRequired && !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)((IBlockAccess)world), (BlockPos)pos2)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos2, state2, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private final void destroyBlock(EntityPlayer player, World world, BlockPos pos2, IBlockState state2) {
        Block block = state2.func_177230_c();
        if (player.field_71075_bZ.field_75098_d) {
            world.func_175698_g(pos2);
        }
        if (block.removedByPlayer(state2, world, pos2, player, true)) {
            block.func_176206_d(world, pos2, state2);
        }
    }

    public final boolean removeBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull ItemStack tool, @NotNull BlockPos pos2, boolean dropItem, boolean isToolRequired, boolean particles) {
        IBlockState state2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (!this.canBreakBlock(player, world, pos2, isToolRequired)) {
            return false;
        }
        IBlockState iBlockState = state2 = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        this.destroyBlock(player, world, pos2, iBlockState);
        if (!player.field_71075_bZ.field_75098_d && dropItem) {
            state2.func_177230_c().func_180657_a(world, player, pos2, state2, world.func_175625_s(pos2), tool);
        }
        if (particles) {
            world.func_175718_b(2001, pos2, Block.func_176210_f((IBlockState)state2));
        }
        return true;
    }

    public final boolean removeBlockAndReplant(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, boolean isToolRequired, boolean particles) {
        IBlockState state2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (!this.canBreakBlock(player, world, pos2, isToolRequired)) {
            return false;
        }
        IBlockState iBlockState = state2 = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        this.destroyBlock(player, world, pos2, iBlockState);
        this.harvestBlockAndReplant(world, player, pos2, state2, 0);
        if (particles) {
            world.func_175718_b(2001, pos2, Block.func_176210_f((IBlockState)state2));
        }
        return true;
    }

    private final void harvestBlockAndReplant(World world, EntityPlayer player, BlockPos pos2, IBlockState state2, int fortune) {
        Block block = state2.func_177230_c();
        StatBase statBase = StatList.func_188055_a((Block)block);
        if (statBase == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.stats.StatBase");
        }
        player.func_71029_a(statBase);
        player.func_71020_j(0.005f);
        float chance = 1.0f;
        NonNullList drops = NonNullList.func_191196_a();
        state2.func_177230_c().getDrops(drops, (IBlockAccess)world, pos2, state2, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting((List)((List)drops), (World)world, (BlockPos)pos2, (IBlockState)state2, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)player);
        IPlantable seed = null;
        for (ItemStack drop : drops) {
            if (drop == null || !(drop.func_77973_b() instanceof IPlantable)) continue;
            Item item = drop.func_77973_b();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.common.IPlantable");
            }
            seed = (IPlantable)item;
            drop.func_190918_g(1);
            if (!drop.func_190926_b()) break;
            drops.remove((Object)drop);
            break;
        }
        if (seed != null) {
            IBlockState down;
            IBlockState iBlockState = down = world.func_180495_p(pos2.func_177977_b());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"down");
            if (iBlockState.func_177230_c().canSustainPlant(down, (IBlockAccess)world, pos2.func_177977_b(), EnumFacing.UP, seed)) {
                IBlockState crop = seed.getPlant((IBlockAccess)world, pos2);
                if (crop != state2) {
                    world.func_175656_a(pos2, seed.getPlant((IBlockAccess)world, pos2));
                }
                for (ItemStack drop : drops) {
                    if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                    Block.func_180635_a((World)world, (BlockPos)pos2, (ItemStack)drop);
                }
            }
        }
    }

    public final boolean smeltBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2) {
        ItemStack result;
        IBlockState state2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (world.field_72995_K) {
            return false;
        }
        if (!world.func_175660_a(player, pos2)) {
            return false;
        }
        IBlockState iBlockState = state2 = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        Block block = iBlockState.func_177230_c();
        int meta = block.func_176201_c(state2);
        ItemStack stack2 = new ItemStack(block, 1, meta);
        ItemStack itemStack = result = FurnaceRecipes.func_77602_a().func_151395_a(stack2);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"result");
        if (itemStack.func_190926_b()) {
            return false;
        }
        Block blockResult = Block.func_149634_a((Item)result.func_77973_b());
        if (blockResult == Blocks.field_150350_a) {
            return false;
        }
        world.func_175656_a(pos2, blockResult.func_176203_a(result.func_77960_j()));
        state2 = world.func_180495_p(pos2);
        world.func_175718_b(2001, pos2, Block.func_176210_f((IBlockState)state2));
        return true;
    }

    public final boolean replaceBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        IBlockState iBlockState = block.func_176223_P();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"block.defaultState");
        return this.replaceBlock(player, world, pos2, iBlockState);
    }

    public final boolean replaceBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull IBlockState newState) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        if (!this.canReplaceBlock(player, world, pos2)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos2);
        BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND);
        Intrinsics.checkExpressionValueIsNotNull((Object)placeEvent, (String)"ForgeEventFactory.onPlay\u2026g.UP, EnumHand.MAIN_HAND)");
        if (placeEvent.isCanceled()) {
            return false;
        }
        world.func_175656_a(pos2, newState);
        return true;
    }

    public final boolean replaceBlockWithGoo(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull IBlockState newState) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        if (!this.canReplaceBlock(player, world, pos2)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos2);
        BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND);
        Intrinsics.checkExpressionValueIsNotNull((Object)placeEvent, (String)"ForgeEventFactory.onPlay\u2026g.UP, EnumHand.MAIN_HAND)");
        if (placeEvent.isCanceled()) {
            return false;
        }
        IBlockState gooState = ModBlocks.INSTANCE.getEthereal_goo().func_176223_P();
        world.func_175656_a(pos2, gooState);
        TileEntity tileEntity = world.func_175625_s(pos2);
        if (!(tileEntity instanceof TileEtherealGoo)) {
            tileEntity = null;
        }
        TileEtherealGoo tileEtherealGoo = (TileEtherealGoo)tileEntity;
        if (tileEtherealGoo == null) {
            return false;
        }
        TileEtherealGoo tileEntity2 = tileEtherealGoo;
        tileEntity2.setBlockState(newState);
        tileEntity2.setActualBlockState(newState);
        return true;
    }

    public final boolean replaceBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull ItemStack stack2, @NotNull EnumHand hand2) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        Item item = stack2.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            item = null;
        }
        ItemBlock itemBlock = (ItemBlock)item;
        if (itemBlock == null) {
            return false;
        }
        ItemBlock item2 = itemBlock;
        if (!this.canReplaceBlock(player, world, pos2)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos2);
        BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)hand2);
        Intrinsics.checkExpressionValueIsNotNull((Object)placeEvent, (String)"ForgeEventFactory.onPlay\u2026hot, EnumFacing.UP, hand)");
        if (placeEvent.isCanceled()) {
            return false;
        }
        Block blockToPlace = Block.func_149634_a((Item)((Item)item2));
        IBlockState stateForPlacement = blockToPlace.getStateForPlacement(world, pos2, EnumFacing.UP, 0.0f, 0.0f, 0.0f, stack2.func_77952_i(), (EntityLivingBase)player, hand2);
        item2.placeBlockAt(stack2, player, world, pos2, EnumFacing.UP, 0.0f, 0.0f, 0.0f, stateForPlacement);
        return true;
    }

    public final boolean moveBlock(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumFacing facing) {
        BlockPos shiftPos;
        IBlockState state2;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        IBlockState iBlockState = state2 = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        Block block = iBlockState.func_177230_c();
        if (world.func_175625_s(pos2) != null) {
            return false;
        }
        if (state2.func_185905_o() != EnumPushReaction.NORMAL) {
            return false;
        }
        if (!block.canSilkHarvest(world, pos2, state2, player)) {
            return false;
        }
        if (state2.func_185903_a(player, world, pos2) <= 0.0f) {
            return false;
        }
        if (!this.canBreakBlock(player, world, pos2, false)) {
            return false;
        }
        Vec3i shiftVec = facing.func_176730_m();
        BlockPos blockPos2 = shiftPos = pos2.func_177971_a(shiftVec);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"shiftPos");
        if (!this.canReplaceBlock(player, world, blockPos2)) {
            return false;
        }
        if (!this.isAirOrReplaceable(world, shiftPos)) {
            return false;
        }
        world.func_180501_a(shiftPos, state2, 3);
        world.func_175698_g(pos2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAirOrReplaceable(@NotNull World world, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (world.func_175623_d(pos2)) return true;
        IBlockState iBlockState = world.func_180495_p(pos2);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
        if (!iBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos2)) return false;
        return true;
    }

    public final boolean ignite(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        if (this.isAirOrReplaceable(world, pos2)) {
            BlockFire blockFire = Blocks.field_150480_ab;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockFire, (String)"Blocks.FIRE");
            IBlockState iBlockState = blockFire.func_176223_P();
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"Blocks.FIRE.defaultState");
            bl = this.replaceBlock(player, world, pos2, iBlockState);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean ignite(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos2, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        if (this.ignite(player, world, pos2)) {
            return true;
        }
        Vec3i shift = facing.func_176730_m();
        BlockPos blockPos2 = pos2.func_177971_a(shift);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.add(shift)");
        return this.ignite(player, world, blockPos2);
    }

    @NotNull
    public final ItemStack getSilkDropIfPresent(@NotNull World world, @NotNull IBlockState state2, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (state2.func_177230_c().canSilkHarvest(world, BlockPos.field_177992_a, state2, player)) {
            return this.getSilkTouchDrop(state2);
        }
        ItemStack itemStack = state2.func_177230_c().getPickBlock(state2, null, world, BlockPos.field_177992_a, player);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"state.block.getPickBlock\u2026 BlockPos.ORIGIN, player)");
        return itemStack;
    }

    @NotNull
    public final ItemStack getSilkTouchDrop(@NotNull IBlockState state2) {
        Item item;
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Item item2 = item = Item.func_150898_a((Block)state2.func_177230_c());
        Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"item");
        int meta = item2.func_77614_k() ? state2.func_177230_c().func_180651_a(state2) : 0;
        return new ItemStack(item, 1, meta);
    }

    private UtilBlock() {
    }

    static {
        UtilBlock utilBlock;
        INSTANCE = utilBlock = new UtilBlock();
    }
}

