/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013\u00a8\u0006\u0014"}, d2={"Laurocosh/divinefavor/common/util/UtilBlockPos;", "", "()V", "blockPosToInt", "", "pos", "Lnet/minecraft/util/math/BlockPos;", "deserialize", "Ljava/util/ArrayList;", "array", "", "getMaxCoordinates", "first", "second", "getMinCoordinates", "intToBlockPos", "value", "serialize", "posCollection", "", "divinefavor"})
public final class UtilBlockPos {
    public static final UtilBlockPos INSTANCE;

    @NotNull
    public final BlockPos getMinCoordinates(@NotNull BlockPos first, @NotNull BlockPos second) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        int xMin = Math.min(first.func_177958_n(), second.func_177958_n());
        int yMin = Math.min(first.func_177956_o(), second.func_177956_o());
        int zMin = Math.min(first.func_177952_p(), second.func_177952_p());
        return new BlockPos(xMin, yMin, zMin);
    }

    @NotNull
    public final BlockPos getMaxCoordinates(@NotNull BlockPos first, @NotNull BlockPos second) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        int xMax = Math.max(first.func_177958_n(), second.func_177958_n());
        int yMax = Math.max(first.func_177956_o(), second.func_177956_o());
        int zMax = Math.max(first.func_177952_p(), second.func_177952_p());
        return new BlockPos(xMax, yMax, zMax);
    }

    @NotNull
    public final int[] serialize(@NotNull Collection<? extends BlockPos> posCollection) {
        Intrinsics.checkParameterIsNotNull(posCollection, (String)"posCollection");
        int[] array = new int[posCollection.size() * 3];
        int i = 0;
        for (BlockPos blockPos2 : posCollection) {
            array[i++] = blockPos2.func_177958_n();
            array[i++] = blockPos2.func_177956_o();
            array[i++] = blockPos2.func_177952_p();
        }
        return array;
    }

    @NotNull
    public final ArrayList<BlockPos> deserialize(@NotNull int[] array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        int posCount = array.length / 3;
        ArrayList<BlockPos> posArrayList = new ArrayList<BlockPos>();
        int j = 0;
        for (int i = 0; i < posCount; ++i) {
            int x = array[j++];
            int y = array[j++];
            int z = array[j++];
            posArrayList.add(new BlockPos(x, y, z));
        }
        return posArrayList;
    }

    public final int blockPosToInt(@NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        int x = (pos2.func_177958_n() & 0xFF) << 16;
        int y = (pos2.func_177956_o() & 0xFF) << 8;
        int z = pos2.func_177952_p() & 0xFF;
        return x + y + z;
    }

    @NotNull
    public final BlockPos intToBlockPos(int value) {
        int x = (value & 0xFF0000) >> 16;
        int y = (value & 0xFF00) >> 8;
        int z = value & 0xFF;
        return new BlockPos(x, y, z);
    }

    private UtilBlockPos() {
    }

    static {
        UtilBlockPos utilBlockPos;
        INSTANCE = utilBlockPos = new UtilBlockPos();
    }
}

