/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import aurocosh.divinefavor.common.constants.BlockPosConstants;
import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.util.UtilCoordinates;
import aurocosh.divinefavor.common.util.UtilRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ(\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ@\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\b\u001a\u00020\tJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\tJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020$J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020%2\u0006\u0010 \u001a\u00020$J4\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0013J&\u0010'\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ&\u0010+\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJH\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0013J$\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\t\u00a8\u00064"}, d2={"Laurocosh/divinefavor/common/util/UtilCoordinates;", "", "()V", "findPlaceToStand", "Lnet/minecraft/util/math/BlockPos;", "start", "world", "Lnet/minecraft/world/World;", "limit", "", "findPlaceToStandBelow", "needPlaceToStand", "", "findPlaceToTeleport", "facing", "Lnet/minecraft/util/EnumFacing;", "findPlaceToTeleportAbove", "findPosition", "predicate", "Lkotlin/Function1;", "nextPosFunction", "floodFill", "", "", "expansionDirs", "getBlocksInRadius", "center", "radiusX", "radiusY", "radiusZ", "getBlocksInSphere", "Lkotlin/sequences/Sequence;", "radius", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "origin", "", "Lnet/minecraft/util/math/Vec3d;", "getRandomBlockInRange", "getRandomNeighbour", "xRadius", "yRadius", "zRadius", "getRandomNeighbourSafe", "getRandomNeighbours", "neighbourCount", "minNextNode", "maxNextNode", "cycleLimit", "getSphereOutline", "radiusInternal", "radiusExternal", "divinefavor"})
public final class UtilCoordinates {
    public static final UtilCoordinates INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BlockPos> getRandomNeighbours(@NotNull BlockPos start, int neighbourCount, int minNextNode, int maxNextNode, int cycleLimit, @NotNull Function1<? super BlockPos, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        int neighbourCounter = neighbourCount;
        int cycleCounter = cycleLimit;
        ArrayList<BlockPos> selectedNodes = new ArrayList<BlockPos>();
        ArrayDeque<BlockPos> nodesToVisit = new ArrayDeque<BlockPos>();
        HashSet plannedNodes = new HashSet();
        HashSet<BlockPos> visitedNodes = new HashSet<BlockPos>();
        nodesToVisit.add(start);
        while (!nodesToVisit.isEmpty() && cycleCounter-- > 0 && neighbourCounter-- > 0) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            BlockPos nextNode = (BlockPos)nodesToVisit.remove();
            plannedNodes.remove(nextNode);
            visitedNodes.add(nextNode);
            selectedNodes.add(nextNode);
            BlockPos blockPos2 = nextNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"nextNode");
            if (!((Boolean)predicate2.invoke((Object)blockPos2)).booleanValue()) continue;
            int neighboursToAdd = UtilRandom.INSTANCE.nextInt(minNextNode, maxNextNode);
            Iterable iterable = BlockPosConstants.INSTANCE.getDIRECT_NEIGHBOURS();
            Object object = nextNode;
            void var18_18 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void p1;
                Vec3i vec3i = (Vec3i)item$iv$iv;
                Collection collection = destination$iv$iv;
                BlockPos blockPos3 = object.func_177971_a((Vec3i)p1);
                collection.add(blockPos3);
            }
            $receiver$iv = (List)destination$iv$iv;
            object = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                BlockPos node = (BlockPos)element$iv$iv;
                if (!(!visitedNodes.contains(node) && !plannedNodes.contains(node))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List randomNewNodes = IterableExtensionsKt.selectRandom((List)destination$iv$iv2, neighboursToAdd);
            nodesToVisit.addAll(randomNewNodes);
            plannedNodes.addAll(randomNewNodes);
        }
        return selectedNodes;
    }

    @NotNull
    public final Sequence<BlockPos> getSphereOutline(@NotNull BlockPos center, int radiusInternal, int radiusExternal) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        Sequence<BlockPos> cubeCoordinates = this.getBlocksInSphere(center, radiusExternal);
        int radiusSq = radiusInternal * radiusInternal;
        return SequencesKt.filter(cubeCoordinates, (Function1)((Function1)new Function1<BlockPos, Boolean>(radiusSq, center){
            final /* synthetic */ int $radiusSq;
            final /* synthetic */ BlockPos $center;

            public final boolean invoke(@NotNull BlockPos pos2) {
                Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
                return this.$center.func_177951_i((Vec3i)pos2) >= (double)this.$radiusSq;
            }
            {
                this.$radiusSq = n;
                this.$center = blockPos2;
                super(1);
            }
        }));
    }

    @NotNull
    public final Sequence<BlockPos> getBlocksInSphere(@NotNull BlockPos center, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        List<BlockPos> cubeCoordinates = this.getBlocksInRadius(center, radius, radius, radius);
        int radiusSq = radius * radius;
        return SequencesKt.filter(IterableExtensionsKt.getS((Iterable)cubeCoordinates), (Function1)((Function1)new Function1<BlockPos, Boolean>(radiusSq, center){
            final /* synthetic */ int $radiusSq;
            final /* synthetic */ BlockPos $center;

            public final boolean invoke(@NotNull BlockPos pos2) {
                Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
                return this.$center.func_177951_i((Vec3i)pos2) <= (double)this.$radiusSq;
            }
            {
                this.$radiusSq = n;
                this.$center = blockPos2;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BlockPos> getBlocksInRadius(@NotNull BlockPos center, int radiusX, int radiusY, int radiusZ) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        ArrayList<BlockPos> coordinates2 = new ArrayList<BlockPos>();
        int n = -radiusX;
        int n2 = radiusX;
        if (n <= n2) {
            while (true) {
                void x;
                int n3;
                int n4;
                if ((n4 = -radiusY) <= (n3 = radiusY)) {
                    while (true) {
                        void y;
                        int n5;
                        int n6;
                        if ((n6 = -radiusZ) <= (n5 = radiusZ)) {
                            while (true) {
                                void z;
                                coordinates2.add(center.func_177982_a((int)x, (int)y, (int)z));
                                if (z == n5) break;
                                ++z;
                            }
                        }
                        if (y == n3) break;
                        ++y;
                    }
                }
                if (x == n2) break;
                ++x;
            }
        }
        return coordinates2;
    }

    @NotNull
    public final BlockPos getRandomNeighbourSafe(@NotNull BlockPos center, int xRadius, int yRadius, int zRadius) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        BlockPos destination = this.getRandomNeighbour(center, xRadius, yRadius, zRadius);
        return new BlockPos(destination.func_177958_n(), Math.max(5, destination.func_177956_o()), destination.func_177952_p());
    }

    @NotNull
    public final BlockPos getRandomNeighbour(@NotNull BlockPos center, int xRadius, int yRadius, int zRadius) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        int xShift = UtilRandom.INSTANCE.nextInt(-xRadius, xRadius);
        int yShift = UtilRandom.INSTANCE.nextInt(-yRadius, yRadius);
        int zShift = UtilRandom.INSTANCE.nextInt(-zRadius, zRadius);
        BlockPos blockPos2 = center.func_177982_a(xShift, yShift, zShift);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"center.add(xShift, yShift, zShift)");
        return blockPos2;
    }

    @Nullable
    public final BlockPos getRandomBlockInRange(@NotNull BlockPos center, int radius, int limit, @NotNull Function1<? super BlockPos, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        BlockPos blockPos2 = this.getRandomNeighbour(center, radius, radius, radius);
        if (((Boolean)predicate2.invoke((Object)blockPos2)).booleanValue()) {
            return blockPos2;
        }
        BlockPos blockPos3 = this.findPosition(center, limit, predicate2, (Function1<? super BlockPos, ? extends BlockPos>)((Function1)getRandomBlockInRange.1.INSTANCE));
        if (blockPos3 == null) {
            blockPos3 = this.findPosition(center, limit, predicate2, (Function1<? super BlockPos, ? extends BlockPos>)((Function1)getRandomBlockInRange.2.INSTANCE));
        }
        return blockPos3;
    }

    @Nullable
    public final BlockPos findPlaceToStand(@NotNull BlockPos start, @NotNull World world, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        BlockPos blockPos2 = start.func_177984_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"start.up()");
        BlockPos pos2 = this.findPlaceToStandBelow(blockPos2, world, limit, true);
        BlockPos blockPos3 = pos2;
        if (blockPos3 == null) {
            BlockPos blockPos4 = start.func_177977_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"start.down()");
            blockPos3 = this.findPlaceToTeleportAbove(blockPos4, world, limit);
        }
        return blockPos3;
    }

    @Nullable
    public final BlockPos findPlaceToTeleport(@NotNull BlockPos start, @NotNull World world, @NotNull EnumFacing facing, int limit, boolean needPlaceToStand) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        int limitCounter = limit;
        BlockPos pos2 = start;
        while (limitCounter-- > 0) {
            IBlockState state2;
            Intrinsics.checkExpressionValueIsNotNull((Object)pos2.func_177972_a(facing), (String)"pos.offset(facing)");
            if (!world.func_175623_d(pos2) || !world.func_175623_d(pos2.func_177984_a())) continue;
            if (!needPlaceToStand) {
                return pos2;
            }
            IBlockState iBlockState = state2 = world.func_180495_p(pos2.func_177977_b());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (iBlockState.func_177230_c() == Blocks.field_150357_h) {
                return null;
            }
            if (!state2.isSideSolid((IBlockAccess)world, pos2.func_177977_b(), EnumFacing.UP)) continue;
            return pos2;
        }
        return null;
    }

    @Nullable
    public final BlockPos findPlaceToTeleportAbove(@NotNull BlockPos start, @NotNull World world, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int limitCounter = limit;
        BlockPos pos2 = start;
        boolean previousSecondIsAir = false;
        boolean previousOneIsAir = false;
        while (limitCounter-- > 0) {
            IBlockState state2;
            Intrinsics.checkExpressionValueIsNotNull((Object)pos2.func_177984_a(), (String)"pos.up()");
            if (previousOneIsAir && previousSecondIsAir) {
                return pos2.func_177977_b();
            }
            IBlockState iBlockState = state2 = world.func_180495_p(pos2);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (iBlockState.func_177230_c() == Blocks.field_150357_h) {
                return null;
            }
            previousSecondIsAir = previousOneIsAir;
            previousOneIsAir = world.func_175623_d(pos2);
        }
        return null;
    }

    @Nullable
    public final BlockPos findPlaceToStandBelow(@NotNull BlockPos start, @NotNull World world, int limit, boolean needPlaceToStand) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int limitCounter = limit;
        BlockPos pos2 = start;
        boolean previousSecondIsAir = false;
        boolean previousOneIsAir = false;
        while (limitCounter-- > 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)pos2.func_177977_b(), (String)"pos.down()");
            IBlockState state2 = world.func_180495_p(pos2);
            if (previousOneIsAir && previousSecondIsAir && (!needPlaceToStand || state2.isSideSolid((IBlockAccess)world, pos2, EnumFacing.UP))) {
                return pos2.func_177984_a();
            }
            IBlockState iBlockState = state2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (iBlockState.func_177230_c() == Blocks.field_150357_h) {
                return null;
            }
            previousSecondIsAir = previousOneIsAir;
            previousOneIsAir = world.func_175623_d(pos2);
        }
        return null;
    }

    @Nullable
    public final BlockPos findPosition(@NotNull BlockPos start, int limit, @NotNull Function1<? super BlockPos, Boolean> predicate2, @NotNull Function1<? super BlockPos, ? extends BlockPos> nextPosFunction) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(nextPosFunction, (String)"nextPosFunction");
        int limitCounter = limit;
        BlockPos pos2 = start;
        while (limitCounter-- > 0) {
            if (((Boolean)predicate2.invoke((Object)pos2)).booleanValue()) {
                return pos2;
            }
            pos2 = (BlockPos)nextPosFunction.invoke((Object)pos2);
        }
        return null;
    }

    @NotNull
    public final List<BlockPos> floodFill(@NotNull Collection<? extends BlockPos> start, @NotNull Collection<? extends BlockPos> expansionDirs, @NotNull Function1<? super BlockPos, Boolean> predicate2, int limit) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(expansionDirs, (String)"expansionDirs");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        ArrayDeque<? extends BlockPos> expansionFront = new ArrayDeque<BlockPos>(start);
        HashSet<? extends BlockPos> explored = new HashSet<BlockPos>(start);
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        while (expansionFront.size() > 0 && result.size() < limit) {
            BlockPos nextPos;
            BlockPos blockPos2 = nextPos = expansionFront.remove();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"nextPos");
            if (!((Boolean)predicate2.invoke((Object)blockPos2)).booleanValue()) continue;
            result.add(nextPos);
            for (BlockPos blockPos3 : expansionDirs) {
                BlockPos neighbour = nextPos.func_177971_a((Vec3i)blockPos3);
                if (explored.contains(neighbour)) continue;
                expansionFront.add((BlockPos)neighbour);
                explored.add((BlockPos)neighbour);
            }
        }
        return result;
    }

    @NotNull
    public final AxisAlignedBB getBoundingBox(@NotNull BlockPos origin, double radius) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new AxisAlignedBB((double)origin.func_177958_n() - radius, (double)origin.func_177956_o() - radius, (double)origin.func_177952_p() - radius, (double)origin.func_177958_n() + radius, (double)origin.func_177956_o() + radius, (double)origin.func_177952_p() + radius);
    }

    @NotNull
    public final AxisAlignedBB getBoundingBox(@NotNull Vec3d origin, double radius) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new AxisAlignedBB(origin.field_72450_a - radius, origin.field_72448_b - radius, origin.field_72449_c - radius, origin.field_72450_a + radius, origin.field_72448_b + radius, origin.field_72449_c + radius);
    }

    private UtilCoordinates() {
    }

    static {
        UtilCoordinates utilCoordinates;
        INSTANCE = utilCoordinates = new UtilCoordinates();
    }
}

