/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import aurocosh.divinefavor.common.config.common.ConfigCurses;
import aurocosh.divinefavor.common.lib.extensions.LivingBaseExtensionsKt;
import aurocosh.divinefavor.common.potions.base.effect.ModEffect;
import aurocosh.divinefavor.common.util.UtilRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Laurocosh/divinefavor/common/util/UtilCurses;", "", "()V", "applyCurse", "", "victim", "Lnet/minecraft/entity/EntityLivingBase;", "caster", "effect", "Laurocosh/divinefavor/common/potions/base/effect/ModEffect;", "getCurseResistance", "", "divinefavor"})
public final class UtilCurses {
    public static final UtilCurses INSTANCE;

    public final void applyCurse(@NotNull EntityLivingBase victim, @NotNull EntityLivingBase caster, @NotNull ModEffect effect) {
        Intrinsics.checkParameterIsNotNull((Object)victim, (String)"victim");
        Intrinsics.checkParameterIsNotNull((Object)caster, (String)"caster");
        Intrinsics.checkParameterIsNotNull((Object)((Object)effect), (String)"effect");
        effect.setIsCurse();
        float resistance = this.getCurseResistance(victim);
        if (UtilRandom.INSTANCE.rollDice(resistance)) {
            caster.func_70690_d((PotionEffect)effect);
        } else {
            victim.func_70690_d((PotionEffect)effect);
        }
    }

    public final float getCurseResistance(@NotNull EntityLivingBase victim) {
        Intrinsics.checkParameterIsNotNull((Object)victim, (String)"victim");
        float curseResistance = ConfigCurses.baseCurseResistance;
        Object object = EntityList.func_191301_a((Entity)((Entity)victim));
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"EntityList.getKey(victim)?.toString() ?: \"\"");
        Object entityString = object;
        Float f = ConfigCurses.mobResistances.get(entityString);
        curseResistance += f != null ? f.floatValue() : (float)0.0;
        curseResistance += (float)LivingBaseExtensionsKt.getDivineLivingData(victim).getCurseData().getCurseCount() * ConfigCurses.curseResistancePerCurse;
        if (victim instanceof EntityPlayer) {
            curseResistance += ConfigCurses.playerCurseResistance;
        }
        return curseResistance;
    }

    private UtilCurses() {
    }

    static {
        UtilCurses utilCurses;
        INSTANCE = utilCurses = new UtilCurses();
    }
}

